/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.worldgen.configurations.tree.corrupted;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import net.abraxator.moresnifferflowers.worldgen.configurations.ModTreeDecoratorTypes;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class CorruptedSludgeDecorator
extends TreeDecorator {
    public static final MapCodec<CorruptedSludgeDecorator> CODEC = RecordCodecBuilder.mapCodec(p_225996_ -> p_225996_.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(p_226014_ -> Float.valueOf(p_226014_.probability)), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_xz").forGetter(p_226012_ -> p_226012_.exclusionRadiusXZ), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_y").forGetter(p_226010_ -> p_226010_.exclusionRadiusY), (App)BlockStateProvider.CODEC.fieldOf("block_provider").forGetter(p_226008_ -> p_226008_.blockProvider), (App)ExtraCodecs.nonEmptyList((Codec)Direction.CODEC.listOf()).fieldOf("directions").forGetter(p_225998_ -> p_225998_.directions)).apply((Applicative)p_225996_, CorruptedSludgeDecorator::new));
    protected final float probability;
    protected final int exclusionRadiusXZ;
    protected final int exclusionRadiusY;
    protected final BlockStateProvider blockProvider;
    protected final List<Direction> directions;

    public CorruptedSludgeDecorator(float probability, int exclusionRadiusXZ, int exclusionRadiusY, BlockStateProvider blockProvider, List<Direction> directions) {
        this.probability = probability;
        this.exclusionRadiusXZ = exclusionRadiusXZ;
        this.exclusionRadiusY = exclusionRadiusY;
        this.blockProvider = blockProvider;
        this.directions = directions;
    }

    public void place(TreeDecorator.Context context) {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        RandomSource randomsource = context.random();
        for (BlockPos blockpos : Util.shuffledCopy((ObjectArrayList)context.leaves(), (RandomSource)randomsource)) {
            Direction direction;
            BlockPos blockpos1 = blockpos.relative(direction = (Direction)Util.getRandom(this.directions, (RandomSource)randomsource));
            if (set.contains(blockpos1) || !(randomsource.nextFloat() < this.probability)) continue;
            BlockPos blockpos2 = blockpos1.offset(-this.exclusionRadiusXZ, -this.exclusionRadiusY, -this.exclusionRadiusXZ);
            BlockPos blockpos3 = blockpos1.offset(this.exclusionRadiusXZ, this.exclusionRadiusY, this.exclusionRadiusXZ);
            for (BlockPos blockpos4 : BlockPos.betweenClosed((BlockPos)blockpos2, (BlockPos)blockpos3)) {
                set.add(blockpos4.immutable());
            }
            context.setBlock(blockpos1, this.blockProvider.getState(randomsource, blockpos1));
        }
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)ModTreeDecoratorTypes.CORRUPTED_SLUDGE.get();
    }
}

