/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.worldgen.configurations.tree.corrupted;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.abraxator.moresnifferflowers.worldgen.configurations.ModTrunkPlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class CorruptedGiantTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<CorruptedGiantTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(p_70161_ -> CorruptedGiantTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)p_70161_).apply((Applicative)p_70161_, CorruptedGiantTrunkPlacer::new));

    public CorruptedGiantTrunkPlacer(int pBaseHeight, int pHeightRandA, int pBranchCount) {
        super(pBaseHeight, pHeightRandA, pBranchCount);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)ModTrunkPlacerTypes.CORRUPTED_GIANT_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int pFreeTreeHeight, BlockPos pos, TreeConfiguration config) {
        ArrayList<FoliagePlacer.FoliageAttachment> ret = new ArrayList<FoliagePlacer.FoliageAttachment>();
        BlockPos.MutableBlockPos mainTrunk = pos.mutable();
        BlockPos.MutableBlockPos tempTrunk = pos.mutable();
        int trunkRadius = 2;
        int trunkHeight = 3;
        int treeHeight = random.nextIntBetweenInclusive(0, this.heightRandA) + pFreeTreeHeight;
        int branchRnd = random.nextIntBetweenInclusive(0, 3);
        for (int d = 0; d < 12; ++d) {
            this.addDirt(mainTrunk.immutable(), ret, blockSetter, level, config, random, d);
        }
        for (int i = 0; i < treeHeight; ++i) {
            int u;
            if (i == 0) {
                tempTrunk.set((Vec3i)mainTrunk);
                this.placeLog(level, blockSetter, random, (BlockPos)tempTrunk, config);
                this.placeLog(level, blockSetter, random, (BlockPos)tempTrunk.move(Direction.NORTH), config);
                this.placeLog(level, blockSetter, random, (BlockPos)tempTrunk.move(Direction.EAST), config);
                this.placeLog(level, blockSetter, random, (BlockPos)tempTrunk.move(Direction.SOUTH), config);
                this.placeLog(level, blockSetter, random, (BlockPos)tempTrunk.move(Direction.SOUTH), config);
                this.placeLog(level, blockSetter, random, (BlockPos)tempTrunk.move(Direction.WEST), config);
                this.placeLog(level, blockSetter, random, (BlockPos)tempTrunk.move(Direction.WEST), config);
                this.placeLog(level, blockSetter, random, (BlockPos)tempTrunk.move(Direction.NORTH), config);
                this.placeLog(level, blockSetter, random, (BlockPos)tempTrunk.move(Direction.NORTH), config);
                for (int trunkOrder = 0; trunkOrder < trunkRadius * 2 * 4; ++trunkOrder) {
                    this.fattenTrunk(level, blockSetter, random, pos, config, trunkOrder, ret, trunkHeight, trunkRadius);
                }
                for (u = 0; u < trunkHeight * 2; ++u) {
                    mainTrunk.move(Direction.UP);
                }
            }
            for (u = 0; u < 4; ++u) {
                int z;
                tempTrunk.set((Vec3i)mainTrunk);
                this.placeLog(level, blockSetter, random, (BlockPos)tempTrunk, config);
                int n = u == 0 ? 1 : (z = u == 1 ? -1 : 0);
                int x = u == 2 ? 1 : (u == 3 ? -1 : 0);
                tempTrunk.move(x, 0, z);
                this.placeLog(level, blockSetter, random, (BlockPos)tempTrunk, config);
                if (!(random.nextFloat() < 0.3f) || i >= treeHeight - 4) continue;
                tempTrunk.set((Vec3i)mainTrunk);
                Direction randDir = Direction.getRandom((RandomSource)random);
                if (randDir.getAxis() == Direction.Axis.Y) continue;
                tempTrunk.move(randDir);
                tempTrunk.move(randDir.getCounterClockWise());
                for (int p = 0; p < random.nextIntBetweenInclusive(2, 4); ++p) {
                    this.placeLog(level, blockSetter, random, (BlockPos)tempTrunk, config);
                    tempTrunk.move(Direction.UP);
                }
            }
            if (i % 4 == 2 && i < treeHeight - 5) {
                int branchOrder = branchRnd + Mth.floor((float)((float)i / 4.0f));
                if (random.nextFloat() < 0.3f && branchOrder > 1) {
                    branchOrder -= 2;
                }
                this.addSmallBranch(mainTrunk.immutable(), ret, blockSetter, level, config, random, branchOrder);
            }
            if (i == treeHeight - 1) {
                for (int c = 0; c < this.heightRandB; ++c) {
                    this.addTopBranch(mainTrunk.immutable(), ret, blockSetter, level, config, random, c);
                }
            }
            mainTrunk.move(Direction.UP);
        }
        return ret;
    }

    private void fattenTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos posOriginal, TreeConfiguration config, int trunkOrder, List<FoliagePlacer.FoliageAttachment> ret, int trunkRadius, int trunkHeight) {
        BlockPos.MutableBlockPos pos = posOriginal.mutable();
        boolean hasDoor = random.nextFloat() < 0.3f && trunkOrder % 4 == 1;
        Vec3i trunkOffset = switch (Mth.floor((float)((float)trunkOrder / 4.0f))) {
            case 0 -> new Vec3i(trunkOrder % 4 - 1, 0, 1);
            case 1 -> new Vec3i(-1, 0, trunkOrder % 4 - 1);
            case 2 -> new Vec3i(-(trunkOrder % 4 - 1), 0, -1);
            case 3 -> new Vec3i(1, 0, -(trunkOrder % 4 - 1));
            default -> new Vec3i(0, 0, 0);
        };
        Direction trunkDir = switch (Mth.floor((float)((float)trunkOrder / 4.0f))) {
            case 0 -> Direction.NORTH;
            case 1 -> Direction.EAST;
            case 2 -> Direction.SOUTH;
            case 3 -> Direction.WEST;
            default -> Direction.NORTH;
        };
        for (int i = 0; i < trunkRadius + 1; ++i) {
            pos.move(trunkDir);
        }
        pos.move(trunkOffset);
        if (trunkOrder % 4 == 3) {
            pos.move(trunkDir.getOpposite());
        }
        int x = 0;
        while (trunkOrder % 4 == 1 ? x <= trunkHeight + 1 : x <= trunkHeight) {
            if (hasDoor && x < 2) {
                pos.move(Direction.UP);
            } else {
                this.placeLog(level, blockSetter, random, (BlockPos)pos, config);
                pos.move(Direction.UP);
            }
            ++x;
        }
        if (trunkOrder % 4 != 3) {
            for (int y = 0; y < 3; ++y) {
                pos.move(trunkDir.getOpposite());
                this.placeLog(level, blockSetter, random, (BlockPos)pos, config);
                if (y == 0) {
                    pos.move(Direction.UP);
                    this.placeLog(level, blockSetter, random, (BlockPos)pos, config);
                }
                pos.move(Direction.UP);
            }
        }
    }

    private void addSmallBranch(BlockPos blockPos, List<FoliagePlacer.FoliageAttachment> ret, BiConsumer<BlockPos, BlockState> blockSetter, LevelSimulatedReader level, TreeConfiguration config, RandomSource random, int branchOrder) {
        int v1;
        Direction direction = CorruptedGiantTrunkPlacer.computeBranchDir(random);
        BlockPos.MutableBlockPos pos = blockPos.relative(direction).mutable();
        BlockPos.MutableBlockPos defaultPos = blockPos.relative(direction).mutable();
        int branchLength = random.nextIntBetweenInclusive(7, 9);
        int branchDir = (int)(360.0f / (float)this.heightRandB) * branchOrder;
        int n = branchOrder % 4 == 0 ? 1 : (v1 = branchOrder % 4 == 2 ? -1 : 0);
        int v3 = branchOrder % 4 == 1 ? 1 : (branchOrder % 4 == 3 ? -1 : 0);
        for (int x = 0; x < branchLength; ++x) {
            float branchHeightRand = (float)x / (float)branchLength;
            if (branchHeightRand < random.nextFloat() & branchHeightRand > 0.0f) {
                this.placeLog(level, blockSetter, random, (BlockPos)pos.move(0, 1, 0), config);
            }
            if ((double)branchHeightRand > (double)random.nextFloat() / 1.5 & branchHeightRand > 0.5f) {
                this.placeLog(level, blockSetter, random, (BlockPos)pos.move(0, -1, 0), config);
            }
            if (x == 0) {
                this.placeLog(level, blockSetter, random, (BlockPos)pos.move(0, 0, 0), config);
            }
            this.placeLog(level, blockSetter, random, (BlockPos)pos.move(v1, 0, v3), config);
            if (x > 1) {
                ret.add(new FoliagePlacer.FoliageAttachment(pos.above(), 0, false));
            }
            if (x != branchLength - 1) continue;
            this.placeLog(level, blockSetter, random, (BlockPos)pos.move(0, -1, 0), config);
        }
    }

    private void addTopBranch(BlockPos blockPos, List<FoliagePlacer.FoliageAttachment> ret, BiConsumer<BlockPos, BlockState> blockSetter, LevelSimulatedReader level, TreeConfiguration config, RandomSource random, int branchOrder) {
        int v1;
        Direction direction = CorruptedGiantTrunkPlacer.computeBranchDir(random);
        BlockPos.MutableBlockPos pos = blockPos.relative(direction).mutable();
        BlockPos.MutableBlockPos defaultPos = blockPos.relative(direction).mutable();
        int branchLength = branchOrder < 4 ? random.nextIntBetweenInclusive(10, 12) : random.nextIntBetweenInclusive(7, 9);
        int branchDir = (int)(360.0f / (float)this.heightRandB) * branchOrder;
        int n = branchOrder % 4 == 0 ? 1 : (v1 = branchOrder % 4 == 2 ? -1 : 0);
        int v3 = branchOrder % 4 == 1 ? 1 : (branchOrder % 4 == 3 ? -1 : 0);
        int v4 = branchOrder % 2 == 0 ? 1 : -1;
        for (int x = 0; x < branchLength; ++x) {
            float branchHeightRand = (float)x / (float)branchLength;
            if (branchHeightRand < random.nextFloat() & branchHeightRand > 0.0f) {
                this.placeLog(level, blockSetter, random, (BlockPos)pos.move(0, 1, 0), config);
            }
            if ((double)branchHeightRand > (double)random.nextFloat() / 1.5 & branchHeightRand > 0.5f) {
                this.placeLog(level, blockSetter, random, (BlockPos)pos.move(0, -1, 0), config);
            }
            if (x == 0) {
                this.placeLog(level, blockSetter, random, (BlockPos)pos.move(0, 0, 0), config);
            }
            this.placeLog(level, blockSetter, random, (BlockPos)pos.move(v1, 0, v3), config);
            if (branchOrder > 3) {
                this.placeLog(level, blockSetter, random, (BlockPos)pos.move(v4 * v3, 0, v4 * v1), config);
            }
            ret.add(new FoliagePlacer.FoliageAttachment(pos.above(), 0, false));
            if (x != branchLength - 1) continue;
            this.placeLog(level, blockSetter, random, (BlockPos)pos.move(0, -1, 0), config);
            ret.add(new FoliagePlacer.FoliageAttachment((BlockPos)pos, 0, false));
        }
    }

    private void addDirt(BlockPos blockPos, List<FoliagePlacer.FoliageAttachment> ret, BiConsumer<BlockPos, BlockState> blockSetter, LevelSimulatedReader level, TreeConfiguration config, RandomSource random, int dirtOrder) {
        int v1;
        int dirtLength = 5;
        BlockPos.MutableBlockPos pos = blockPos.below().mutable();
        int n = dirtOrder % 4 == 0 ? 1 : (v1 = dirtOrder % 4 == 2 ? -1 : 0);
        int v3 = dirtOrder % 4 == 1 ? 1 : (dirtOrder % 4 == 3 ? -1 : 0);
        int v4 = dirtOrder % 2 == 0 ? 1 : -1;
        CorruptedGiantTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos, (TreeConfiguration)config);
        for (int x = 0; x < dirtLength; ++x) {
            CorruptedGiantTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.move(v1, 0, v3), (TreeConfiguration)config);
            if (x == 0 && dirtOrder < 4) {
                CorruptedGiantTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.move(v1, 0, v3), (TreeConfiguration)config);
            }
            if (dirtOrder > 3 && dirtOrder < 8) {
                CorruptedGiantTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.move(v4 * v3, 0, v4 * v1), (TreeConfiguration)config);
            }
            if (dirtOrder <= 7) continue;
            CorruptedGiantTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.move(-v4 * v3, 0, -v4 * v1), (TreeConfiguration)config);
        }
    }

    private static Direction computeBranchDir(RandomSource random) {
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        Direction clockAdjusted = random.nextBoolean() ? direction.getClockWise() : direction.getCounterClockWise();
        return random.nextBoolean() ? direction : clockAdjusted;
    }

    protected boolean validTreePos(LevelSimulatedReader level, BlockPos pos) {
        return true;
    }
}

