/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.nutrition;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.nutrition.Nutrition;
import net.abraxator.moresnifferflowers.nutrition.NutritionEntry;
import net.abraxator.moresnifferflowers.nutrition.NutritionType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class NutritionLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().create();
    private static final Codec<Map<Either<TagKey<Item>, Item>, Integer>> CODEC = Codec.unboundedMap((Codec)Codec.either((Codec)TagKey.hashedCodec((ResourceKey)Registries.ITEM), (Codec)BuiltInRegistries.ITEM.byNameCodec()), (Codec)Codec.INT);
    public static Map<String, Set<Nutrition>> modNutritions = ImmutableMap.of();
    public static Map<NutritionType, Set<Nutrition>> typeNutritions = ImmutableMap.of();
    public static Set<Nutrition> allNutritions = ImmutableSet.of();

    public NutritionLoader() {
        super(GSON, "nutrition");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        HashMap<String, Set<Nutrition>> modNutritions = new HashMap<String, Set<Nutrition>>();
        HashMap<NutritionType, Set<Nutrition>> typeNutritions = new HashMap<NutritionType, Set<Nutrition>>();
        HashSet<Nutrition> allNutritions = new HashSet<Nutrition>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            HashMap currentModNutritions = Maps.newHashMap();
            ResourceLocation path = entry.getKey();
            try {
                for (NutritionType nutritionType : NutritionType.values()) {
                    JsonObject entries = entry.getValue().getAsJsonObject().getAsJsonObject(nutritionType.name);
                    DataResult parse = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entries);
                    if (!parse.isSuccess()) continue;
                    Map values = (Map)parse.getOrThrow();
                    HashMap<Item, NutritionEntry> map = new HashMap<Item, NutritionEntry>();
                    for (Map.Entry mapEntry : values.entrySet()) {
                        Set<Object> itemList = new HashSet();
                        if (((Either)mapEntry.getKey()).left().isPresent()) {
                            itemList = Arrays.stream(Ingredient.of((TagKey)((TagKey)((Either)mapEntry.getKey()).left().get())).getItems()).map(ItemStack::getItem).collect(Collectors.toSet());
                        }
                        if (((Either)mapEntry.getKey()).right().isPresent()) {
                            itemList = Set.of((Item)((Either)mapEntry.getKey()).right().get());
                        }
                        for (Item item2 : itemList) {
                            map.put(item2, new NutritionEntry(nutritionType, (Integer)mapEntry.getValue()));
                        }
                    }
                    map.forEach((item, nutritionEntry) -> {
                        if (nutritionEntry.weight() <= 0) {
                            return;
                        }
                        currentModNutritions.merge(item, new ArrayList<NutritionEntry>(List.of(nutritionEntry)), (existingList, newList) -> {
                            existingList.addAll(newList);
                            return existingList;
                        });
                    });
                }
            }
            catch (JsonParseException | IllegalStateException e) {
                MoreSnifferFlowers.LOGGER.error("Error parsing nutrition {}", (Object)path, (Object)e);
            }
            Set nutritionList = currentModNutritions.entrySet().stream().map(itemListEntry -> new Nutrition((Item)itemListEntry.getKey(), (List)itemListEntry.getValue())).collect(Collectors.toSet());
            modNutritions.put(path.getPath(), nutritionList);
            allNutritions.addAll(nutritionList);
            for (Nutrition nutrition : allNutritions) {
                for (NutritionEntry nutritionEntry2 : nutrition.getNutritionEntries()) {
                    NutritionType type = nutritionEntry2.nutrition();
                    typeNutritions.computeIfAbsent(type, k -> new HashSet()).add(nutrition);
                }
            }
        }
        NutritionLoader.modNutritions = modNutritions;
        NutritionLoader.typeNutritions = typeNutritions;
        NutritionLoader.allNutritions = allNutritions;
    }
}

