/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.networking.toClient;

import io.netty.buffer.ByteBuf;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.init.ModParticles;
import net.abraxator.moresnifferflowers.networking.MSFClientPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public record SaltemoneParticlePacket(Vector3f pos) implements MSFClientPacket
{
    public static final CustomPacketPayload.Type<SaltemoneParticlePacket> TYPE = new CustomPacketPayload.Type(MoreSnifferFlowers.loc("saltemone_particle"));
    public static final StreamCodec<ByteBuf, SaltemoneParticlePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VECTOR3F, SaltemoneParticlePacket::pos, SaltemoneParticlePacket::new);

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleClientPacket(Player player, Level level) {
        RandomSource random = level.random;
        for (int i = 0; i < 5; ++i) {
            Particle particle = Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ModParticles.BUBBLE.get(), (double)this.pos.x + random.nextDouble() - 0.5, (double)this.pos.y + random.nextDouble() - 0.5, (double)this.pos.z + random.nextDouble() - 0.5, (random.nextDouble() - 0.5) / 2.0, (random.nextDouble() - 0.5) * 2.0, (random.nextDouble() - 0.5) / 2.0);
            if (particle == null) continue;
            particle.scale(0.5f + random.nextFloat());
            particle.setLifetime(random.nextIntBetweenInclusive(15, 25));
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

