/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.networking.toClient;

import io.netty.buffer.ByteBuf;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.networking.MSFClientPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public record CorruptionParticlePacket(BlockPos pos, boolean isPositive, boolean isFlower) implements MSFClientPacket
{
    public static final CustomPacketPayload.Type<CorruptionParticlePacket> TYPE = new CustomPacketPayload.Type(MoreSnifferFlowers.loc("corruption_particle"));
    public static final StreamCodec<ByteBuf, CorruptionParticlePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, CorruptionParticlePacket::pos, (StreamCodec)ByteBufCodecs.BOOL, CorruptionParticlePacket::isPositive, (StreamCodec)ByteBufCodecs.BOOL, CorruptionParticlePacket::isFlower, CorruptionParticlePacket::new);

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleClientPacket(Player player, Level level) {
        RandomSource random = level.random;
        BlockState state = level.getBlockState(this.pos);
        Vec3 vec = this.pos.getCenter();
        if (this.isFlower) {
            Vec3 offset = state.getOffset((BlockGetter)level, this.pos).add(vec);
            vec.add(offset);
            for (int i = 0; i < 10; ++i) {
                double inaccuracy = 0.7;
                double xOff = (double)(random.nextFloat() - 0.5f) * inaccuracy;
                double zOff = (double)(random.nextFloat() - 0.5f) * inaccuracy;
                double yOff = random.nextFloat() / 2.0f;
                level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, offset.x + xOff, offset.y + yOff, offset.z + zOff, 0.0, 0.2, 0.0);
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                double xOff = random.nextFloat() - 0.5f;
                double zOff = random.nextFloat() - 0.5f;
                double yOff = random.nextFloat() / 3.0f + 0.5f;
                double slowDown = 3.0;
                SimpleParticleType particle = this.isPositive ? ParticleTypes.HAPPY_VILLAGER : new DustParticleOptions(new Vector3f(0.41960785f, 0.24313726f, 0.47843137f), random.nextFloat() / 2.0f + 0.5f);
                level.addParticle((ParticleOptions)particle, vec.x + xOff, vec.y + yOff, vec.z + zOff, xOff / slowDown, 0.2, zOff / slowDown);
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

