/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.items;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import net.abraxator.moresnifferflowers.init.ModParticles;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public class WandOfCubingItem
extends Item {
    public WandOfCubingItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Vec3 pos = context.getClickedPos().getCenter();
        int r = 5;
        float angle = 0.7853982f;
        Map map = (Map)Util.make((Object)Maps.newLinkedHashMap(), o -> {
            o.put(0, Blocks.WHITE_WOOL.defaultBlockState());
            o.put(1, Blocks.GRAY_WOOL.defaultBlockState());
            o.put(2, Blocks.BROWN_WOOL.defaultBlockState());
            o.put(3, Blocks.GREEN_WOOL.defaultBlockState());
            o.put(4, Blocks.YELLOW_WOOL.defaultBlockState());
            o.put(5, Blocks.RED_WOOL.defaultBlockState());
        });
        for (int x = -r; x <= r; ++x) {
            for (int y = -r; y <= r; ++y) {
                for (int z = -r; z <= r; ++z) {
                    if (this.shouldRemoveBlock(x, y, z, r)) continue;
                    Vector3d vec3 = new Vector3d((double)x, (double)y, (double)z);
                    context.getLevel().setBlock(new BlockPos((int)(pos.x + vec3.x), (int)(pos.y + vec3.y), (int)(pos.z + vec3.z)), (BlockState)map.get(Math.min(Math.min(Mth.abs((int)x), Mth.abs((int)y)), Mth.abs((int)z))), 3);
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide);
    }

    private boolean isOnEdge(int x, int y, int z, int r) {
        int absX = Mth.abs((int)x);
        int absY = Mth.abs((int)y);
        int absZ = Mth.abs((int)z);
        return absX != r && absY == r && absZ != r || absX == r && absY != r && absZ != r || absX != r && absY != r && absZ == r;
    }

    private boolean shouldRemoveBlock(int x, int y, int z, int r) {
        if (y == 0) {
            return Mth.abs((int)x) == r && Mth.abs((int)z) == r;
        }
        if (Mth.abs((int)y) == 1) {
            return Mth.abs((int)x) == r || Mth.abs((int)z) == r;
        }
        if (x == 0) {
            return Mth.abs((int)y) == r && Mth.abs((int)z) == r;
        }
        if (Mth.abs((int)x) == 1) {
            return Mth.abs((int)y) == r || Mth.abs((int)z) == r;
        }
        if (z == 0) {
            return Mth.abs((int)y) == r && Mth.abs((int)x) == r;
        }
        if (Mth.abs((int)z) == 1) {
            return Mth.abs((int)y) == r || Mth.abs((int)x) == r;
        }
        return false;
    }

    private void generateParticle(UseOnContext context, Set<Vec3> set, double xo, double yo, double zo, double r, double theta, double checkR) {
        double x = xo + r * (double)Mth.cos((float)((float)theta));
        double yx = yo + r * (double)Mth.sin((float)((float)theta));
        double yz = yo + r * (double)Mth.cos((float)((float)theta));
        double z = zo + r * (double)Mth.sin((float)((float)theta));
        this.createAndAddParticle(context, set, checkR, new Vec3(x, yo, z));
        this.createAndAddParticle(context, set, checkR, new Vec3(x, yx, zo));
        this.createAndAddParticle(context, set, checkR, new Vec3(xo, yz, z));
    }

    private void createAndAddParticle(UseOnContext context, Set<Vec3> set, double checkR, Vec3 vec3) {
        AABB aabb = AABB.ofSize((Vec3)vec3, (double)checkR, (double)checkR, (double)checkR);
        if (set.stream().noneMatch(arg_0 -> ((AABB)aabb).contains(arg_0))) {
            context.getLevel().addParticle((ParticleOptions)ModParticles.CARROT.get(), vec3.x, vec3.y, vec3.z, 0.0, 0.0, 0.0);
            set.add(vec3);
        }
    }
}

