/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.abraxator.moresnifferflowers.init.ModEffects;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BottleOfExtractionItem
extends Item {
    public BottleOfExtractionItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity pLivingEntity) {
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            if (!level.isClientSide) {
                if (pLivingEntity instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)pLivingEntity;
                    CriteriaTriggers.CONSUME_ITEM.trigger(serverplayer, stack);
                    serverplayer.awardStat(Stats.ITEM_USED.get((Object)this));
                }
                if (player.hasEffect(ModEffects.EXTRACTED)) {
                    BottleOfExtractionItem.doCheaterEasterEgg(level, player);
                    return new ItemStack((ItemLike)Items.POISONOUS_POTATO);
                }
                ArrayList<MobEffectInstance> activeEffects = new ArrayList(player.getActiveEffects());
                activeEffects = activeEffects.stream().filter(mobEffectInstance -> !mobEffectInstance.getEffect().is(ModTags.ModEffectTags.EXTRACTION_BLACKLIST)).toList();
                stack = this.initPotion(activeEffects);
                activeEffects.forEach(effectInstance -> player.removeEffect(effectInstance.getEffect()));
            }
        }
        return stack;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand pUsedHand) {
        if (!this.canExtract(level, player)) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(pUsedHand));
        }
        player.startUsingItem(pUsedHand);
        return InteractionResultHolder.consume((Object)player.getItemInHand(pUsedHand));
    }

    private ItemStack initPotion(List<MobEffectInstance> activeEffects) {
        ItemStack stack = ((Item)ModItems.EXTRACTED_BOTTLE.get()).getDefaultInstance();
        stack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.empty(), Optional.of(PotionContents.getColor(activeEffects)), new ArrayList<MobEffectInstance>(activeEffects)));
        return stack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity pEntity) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    private boolean canExtract(Level level, Player player) {
        List<Object> activeEffects = new ArrayList(player.getActiveEffects());
        activeEffects = activeEffects.stream().filter(mobEffectInstance -> !mobEffectInstance.getEffect().is(ModTags.ModEffectTags.EXTRACTION_BLACKLIST)).toList();
        return !level.isClientSide && !activeEffects.isEmpty() && !player.hasEffect(ModEffects.EXTRACTED);
    }

    private static void doCheaterEasterEgg(Level level, Player player) {
        player.setAbsorptionAmount(0.0f);
        player.setHealth(0.1f);
        player.addEffect(new MobEffectInstance(MobEffects.POISON, 800, 2));
        player.setSwimming(true);
        player.setJumping(true);
        player.setXRot(0.0f);
        player.setYHeadRot(0.0f);
        level.playSound(null, (Entity)player, SoundEvents.ENDERMAN_SCREAM, SoundSource.PLAYERS, 1.2f, 1.0f);
        level.playSound(null, (Entity)player, SoundEvents.ENDERMAN_SCREAM, SoundSource.PLAYERS, 1.2f, 0.8f);
        level.playSound(null, (Entity)player, SoundEvents.ENDERMAN_SCREAM, SoundSource.PLAYERS, 1.2f, 1.3f);
        level.playSound(null, (Entity)player, SoundEvents.ENDERMAN_SCREAM, SoundSource.PLAYERS, 1.2f, 0.8f);
        level.playSound(null, (Entity)player, SoundEvents.SPLASH_POTION_BREAK, SoundSource.PLAYERS, 1.4f, 1.0f);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, components, tooltipFlag);
        components.add((Component)Component.translatableWithFallback((String)"tooltip.bottle_of_extraction.usage", (String)"Drink to extract all effects into single potion").withStyle(ChatFormatting.GOLD));
    }
}

