/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.entities.goals;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.abraxator.moresnifferflowers.entities.BoblingEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BoblingGiantCropGoal
extends Goal {
    private final BoblingEntity bobling;
    private final int searchArea;
    private final double speed;
    private Vec3 wantedPos;
    private int searchCooldown;
    private int randomInterval;
    private long lastFarmSearchTime;

    public BoblingGiantCropGoal(BoblingEntity bobling, int searchArea, double speed) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        this.bobling = bobling;
        this.searchArea = searchArea;
        this.speed = speed;
        this.randomInterval = BoblingGiantCropGoal.reducedTickDelay((int)10);
        if (this.bobling.getWantedPos() != null && this.bobling.level().getBlockState(this.bobling.getWantedPos().below()).is(Blocks.FARMLAND)) {
            this.wantedPos = this.bobling.getWantedPos().getCenter();
        }
    }

    public boolean canUse() {
        return this.checkFarm(this.findFarm());
    }

    private boolean gonnaPlant() {
        return this.wantedPos != null && this.wantedPos.closerThan((Position)this.bobling.position(), 1.5);
    }

    private boolean checkFarm(Optional<BlockPos> pos) {
        if (this.randomInterval > 0 && this.bobling.getRandom().nextInt(this.randomInterval + (this.bobling.getWantedPos() != null ? 5 : 0)) != 0) {
            long currentTime = this.bobling.level().getGameTime();
            if (this.searchCooldown <= 0 && (this.lastFarmSearchTime == 0L || currentTime - this.lastFarmSearchTime > 100L)) {
                pos = this.findFarm();
                this.searchCooldown = 100;
                this.lastFarmSearchTime = currentTime;
            }
            pos.ifPresent(blockPos -> {
                this.wantedPos = blockPos.getCenter();
                this.bobling.setWantedPos(Optional.of(BlockPos.containing((Position)this.wantedPos)));
                this.bobling.getNavigation().moveTo(this.wantedPos.x, this.wantedPos.y, this.wantedPos.z, this.speed);
            });
        }
        return this.wantedPos != null;
    }

    private Optional<BlockPos> findFarm() {
        Level level = this.bobling.level();
        AABB entityAABB = new AABB(BlockPos.containing((Position)this.bobling.position())).inflate((double)this.searchArea, 3.0, (double)this.searchArea);
        List<BlockPos> nearbyFarmlandsPos = BlockPos.betweenClosedStream((AABB)entityAABB).filter(blockPos -> {
            BlockState blockState = level.getBlockState(blockPos);
            return blockState.is(Blocks.FARMLAND);
        }).toList();
        if (nearbyFarmlandsPos.isEmpty()) {
            return Optional.empty();
        }
        Optional randomFarmlandPos = nearbyFarmlandsPos.stream().findAny();
        AABB aabb = AABB.ofSize((Vec3)((BlockPos)randomFarmlandPos.get()).getCenter(), (double)2.0, (double)0.0, (double)2.0).expandTowards(0.0, 3.0, 0.0);
        boolean flag = BlockPos.betweenClosedStream((AABB)aabb).allMatch(blockPos1 -> {
            if (blockPos1.getY() == ((BlockPos)randomFarmlandPos.get()).getY()) {
                return level.getBlockState(blockPos1).is(Blocks.FARMLAND);
            }
            return level.getBlockState(blockPos1).is(Blocks.AIR);
        });
        return flag ? randomFarmlandPos : Optional.empty();
    }

    public boolean canContinueToUse() {
        boolean flag = true;
        if (this.bobling.level().getGameTime() % 50L == 0L) {
            flag = this.checkFarm(Optional.empty());
        }
        return !this.gonnaPlant() && flag;
    }

    public void tick() {
        if (this.searchCooldown >= 100) {
            --this.searchCooldown;
        }
    }
}

