/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.entities.boat;

import net.abraxator.moresnifferflowers.entities.boat.ModBoatEntity;
import net.abraxator.moresnifferflowers.init.ModEntityTypes;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class ModChestBoatEntity
extends ChestBoat {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.defineId(ModChestBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ModChestBoatEntity(EntityType<? extends ChestBoat> entityType, Level level) {
        super(entityType, level);
    }

    public ModChestBoatEntity(Level level, double pX, double pY, double pZ) {
        this((EntityType<? extends ChestBoat>)((EntityType)ModEntityTypes.MOD_CORRUPTED_CHEST_BOAT.get()), level);
        this.setPos(pX, pY, pZ);
        this.xo = pX;
        this.yo = pY;
        this.zo = pZ;
    }

    public Item getDropItem() {
        return switch (this.getModVariant()) {
            default -> throw new MatchException(null, null);
            case ModBoatEntity.Type.CORRUPTED -> (Item)ModItems.CORRUPTED_CHEST_BOAT.get();
            case ModBoatEntity.Type.VIVICUS -> (Item)ModItems.VIVICUS_CHEST_BOAT.get();
        };
    }

    public void setVariant(ModBoatEntity.Type pVariant) {
        this.entityData.set(DATA_ID_TYPE, (Object)pVariant.ordinal());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE, (Object)ModBoatEntity.Type.CORRUPTED.ordinal());
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putString("Type", this.getModVariant().getSerializedName());
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("Type", 8)) {
            this.setVariant(ModBoatEntity.Type.byName(tag.getString("Type")));
        }
    }

    public ModBoatEntity.Type getModVariant() {
        return ModBoatEntity.Type.byId((Integer)this.entityData.get(DATA_ID_TYPE));
    }
}

