/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.entities;

import java.util.Optional;
import net.abraxator.moresnifferflowers.blocks.Corruptable;
import net.abraxator.moresnifferflowers.capability.CorruptionCapability;
import net.abraxator.moresnifferflowers.init.ModAdvancementCritters;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModEntityTypes;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.abraxator.moresnifferflowers.init.SimpleAdvancementTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CorruptedProjectile
extends ThrowableItemProjectile {
    public CorruptedProjectile(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public CorruptedProjectile(Level level, LivingEntity pShooter) {
        super((EntityType)ModEntityTypes.CORRUPTED_SLIME_BALL.get(), pShooter, level);
    }

    public CorruptedProjectile(Level level) {
        super((EntityType)ModEntityTypes.CORRUPTED_SLIME_BALL.get(), level);
    }

    protected Item getDefaultItem() {
        return (Item)ModItems.CORRUPTED_SLIME_BALL.get();
    }

    private ParticleOptions getParticle() {
        return new ItemParticleOption(ParticleTypes.ITEM, this.getItem());
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        for (int i = 0; i < 16; ++i) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
        }
    }

    public void handleEntityEvent(byte id) {
        super.handleEntityEvent(id);
        if (id == 3) {
            this.level().addParticle((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)3549245).toVector3f(), 1.0f), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
            if (!this.level().isClientSide) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 2));
            }
        }
        this.discard();
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        BlockPos pos = result.getBlockPos();
        BlockPos posRelative = result.getBlockPos().relative(result.getDirection());
        BlockPos posRelativeBelow = result.getBlockPos().relative(result.getDirection()).below();
        BlockState state = this.level().getBlockState(pos);
        BlockState stateRelative = this.level().getBlockState(posRelative);
        BlockState stateRelativeBelow = this.level().getBlockState(result.getBlockPos().relative(result.getDirection()).below());
        if (this.level().getBlockState(pos).is(ModTags.ModBlockTags.NO_CORRUPTED_SLIME_COLLISION)) {
            return;
        }
        if (CorruptedProjectile.checkState(this.level().getBlockState(result.getBlockPos()))) {
            Integer layer = (Integer)state.getValue((Property)ModStateProperties.LAYER);
            this.level().setBlockAndUpdate(pos, (BlockState)((Block)ModBlocks.CORRUPTED_SLIME_LAYER.get()).defaultBlockState().setValue((Property)ModStateProperties.LAYER, (Comparable)Integer.valueOf(layer + 1)));
        } else {
            this.transformBlock(this.level(), pos);
            if (CorruptedProjectile.checkState(this.level().getBlockState(result.getBlockPos().relative(result.getDirection())))) {
                Integer layerRelative = (Integer)stateRelative.getValue((Property)ModStateProperties.LAYER);
                this.level().setBlockAndUpdate(posRelative, (BlockState)((Block)ModBlocks.CORRUPTED_SLIME_LAYER.get()).defaultBlockState().setValue((Property)ModStateProperties.LAYER, (Comparable)Integer.valueOf(layerRelative + 1)));
            }
            if (stateRelative.is(Blocks.AIR) || stateRelative.is(BlockTags.FIRE) || stateRelative.canBeReplaced() && !stateRelative.liquid()) {
                if (result.getDirection() == Direction.UP && !state.is(Blocks.AIR)) {
                    this.level().setBlockAndUpdate(result.getBlockPos().relative(result.getDirection()), (BlockState)((Block)ModBlocks.CORRUPTED_SLIME_LAYER.get()).defaultBlockState().setValue((Property)ModStateProperties.LAYER, (Comparable)Integer.valueOf(1)));
                    this.discard();
                } else {
                    CorruptedProjectile projectile = new CorruptedProjectile(this.level());
                    projectile.setPos(this.getX(), this.getY(), this.getZ());
                    projectile.setRot(this.getYRot(), (float)Math.PI / 90);
                    this.level().addFreshEntity((Entity)projectile);
                }
            } else if (net.abraxator.moresnifferflowers.data.datamaps.Corruptable.canBeCorrupted(stateRelative.getBlock(), this.random)) {
                this.transformBlock(this.level(), posRelative);
            }
        }
        this.discard();
    }

    private boolean transformBlock(Level level, BlockPos blockPos) {
        Optional pos = BlockPos.findClosestMatch((BlockPos)blockPos, (int)1, (int)1, blockPos1 -> net.abraxator.moresnifferflowers.data.datamaps.Corruptable.canBeCorrupted(level.getBlockState(blockPos1).getBlock(), this.random));
        BlockState state = level.getBlockState(blockPos);
        if (net.abraxator.moresnifferflowers.data.datamaps.Corruptable.canBeCorrupted(state.getBlock(), this.random)) {
            Optional<Block> optional = net.abraxator.moresnifferflowers.data.datamaps.Corruptable.getCorruptedBlock(state.getBlock(), this.random);
            optional.ifPresent(arg_0 -> this.lambda$transformBlock$1(level, blockPos, state, arg_0));
            return true;
        }
        return false;
    }

    private static boolean checkState(BlockState state) {
        return state.is(ModBlocks.CORRUPTED_SLIME_LAYER) && (Integer)state.getValue((Property)ModStateProperties.LAYER) != 8;
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$transformBlock$1(Level level, BlockPos blockPos, BlockState state, Block block) {
        patt0$temp = level.getBlockState(blockPos).getBlock();
        if (!(patt0$temp instanceof Corruptable)) ** GOTO lbl-1000
        corruptable = (Corruptable)patt0$temp;
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            corruptable.onCorrupt((Level)serverLevel, blockPos, level.getBlockState(blockPos), block);
        } else lbl-1000:
        // 2 sources

        {
            level.setBlockAndUpdate(blockPos, block.withPropertiesOf(state));
            CorruptionCapability.onCorruptionSource(level, blockPos);
        }
        patt1$temp = level.getNearestPlayer((Entity)this, 15.0);
        if (patt1$temp instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)patt1$temp;
            ((SimpleAdvancementTrigger)ModAdvancementCritters.CORRUPTED_BLOCK.get()).trigger(serverPlayer);
        }
        level.addParticle((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)4469320).toVector3f(), 1.0f), (double)blockPos.getX() + level.random.nextDouble(), (double)blockPos.getY() + level.random.nextDouble(), (double)blockPos.getZ() + level.random.nextDouble(), 0.0, 0.0, 0.0);
    }
}

