/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.effects;

import net.abraxator.moresnifferflowers.capability.UntouchableCapability;
import net.abraxator.moresnifferflowers.init.ModDataAttachments;
import net.abraxator.moresnifferflowers.networking.toClient.SyncUntouchablePacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public class UntouchableEffect
extends MobEffect {
    public UntouchableEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ((UntouchableCapability)player.getData(ModDataAttachments.UNTOUCHABLE.get())).tick(player, amplifier);
        }
        return true;
    }

    public void onMobHurt(LivingEntity livingEntity, int amplifier, DamageSource damageSource, float amount) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            ((UntouchableCapability)player.getData(ModDataAttachments.UNTOUCHABLE.get())).onAttacked();
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncUntouchablePacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

