/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.data.recipe.builder;

import java.util.LinkedHashMap;
import java.util.Map;
import net.abraxator.moresnifferflowers.recipes.CropressingRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class CropressingRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    private Ingredient ingredient;
    private int count;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public CropressingRecipeBuilder(ItemLike result) {
        this.result = result.asItem();
    }

    public RecipeBuilder requiresCrop(Item crop) {
        this.ingredient = Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)crop)});
        this.count = 16;
        return this;
    }

    public RecipeBuilder unlockedBy(String pName, Criterion<?> pCriterion) {
        this.criteria.put(pName, pCriterion);
        return this;
    }

    public RecipeBuilder group(@Nullable String pGroupName) {
        return this;
    }

    public Item getResult() {
        return this.result;
    }

    public void save(RecipeOutput pRecipeOutput, ResourceLocation pId) {
        this.ensureValid(pId);
        Advancement.Builder advancement = pRecipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)pId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)pId)).requirements(AdvancementRequirements.Strategy.OR);
        CropressingRecipe cropressingRecipe = new CropressingRecipe(this.ingredient, this.count, this.result.getDefaultInstance());
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement).addCriterion(arg_0, arg_1));
        pRecipeOutput.accept(pId, (Recipe)cropressingRecipe, advancement.build(pId));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
        }
    }
}

