/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.components;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.abraxator.moresnifferflowers.components.Dye;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.items.DyespriaItem;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import oshi.util.tuples.Pair;

public interface Colorable {
    public static final String TAG_HEX = "MSF_Hex";
    public static final String TAG_ID = "MSF_ID";

    default public TagKey<Block> matchTag() {
        return null;
    }

    default public Pair<EnumProperty<DyeColor>, BooleanProperty> getColorAndEmptyProperties() {
        return new Pair(ModStateProperties.COLOR, (Object)ModStateProperties.EMPTY);
    }

    default public boolean canBeColored(BlockState blockState, Dye dye) {
        return !this.getDyeFromBlock(blockState).color().equals((Object)dye.color());
    }

    default public Dye getDyeFromBlock(BlockState blockState) {
        DyeColor dyeColor = DyeColor.WHITE;
        boolean empty = true;
        if (blockState.hasProperty((Property)this.getColorAndEmptyProperties().getA())) {
            dyeColor = (DyeColor)blockState.getValue((Property)this.getColorAndEmptyProperties().getA());
        }
        if (blockState.hasProperty((Property)this.getColorAndEmptyProperties().getB())) {
            empty = (Boolean)blockState.getValue((Property)this.getColorAndEmptyProperties().getB());
        }
        return new Dye(dyeColor, !empty ? 1 : 0);
    }

    default public void colorBlock(Level level, BlockPos blockPos, BlockState blockState, Dye dye) {
        level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)this.getColorAndEmptyProperties().getA(), (Comparable)dye.color()));
    }

    default public boolean isColorEmpty(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)this.getColorAndEmptyProperties().getB());
    }

    default public ItemStack add(@Nullable ItemStack dyespria, Dye dyeInside, ItemStack dyeToInsert) {
        if (!(dyeToInsert.getItem() instanceof DyeItem)) {
            return dyeToInsert;
        }
        if (dyeInside.isEmpty()) {
            this.onAddDye(dyespria, dyeToInsert, dyeToInsert.getCount());
            return ItemStack.EMPTY;
        }
        if (!Dye.dyeCheck(dyeInside, dyeToInsert)) {
            this.onAddDye(dyespria, dyeToInsert, dyeToInsert.getCount());
            dyeToInsert.shrink(dyeToInsert.getCount());
            ItemStack returnStack = Dye.stackFromDye(dyeInside);
            if (DyespriaItem.getDyespriaUses(dyespria) < 4) {
                returnStack.shrink(1);
                DyespriaItem.setDyespriaUses(dyespria, 4);
            }
            return returnStack;
        }
        int amountInside = dyeInside.amount();
        int freeSpace = 64 - amountInside;
        if (freeSpace <= 0) {
            return dyeToInsert;
        }
        int amountToAdd = Math.min(dyeToInsert.getCount(), freeSpace);
        this.onAddDye(dyespria, dyeToInsert, amountInside + amountToAdd);
        dyeToInsert.shrink(amountToAdd);
        return dyeToInsert;
    }

    default public void onAddDye(@Nullable ItemStack destinationStack, ItemStack dye, int amount) {
    }

    default public void particles(RandomSource randomSource, Level level, Dye dye, BlockPos blockPos) {
        this.particles(randomSource, level, dye, blockPos, null);
    }

    default public void particles(RandomSource randomSource, Level level, Dye dye, BlockPos blockPos, @Nullable Direction face) {
        Vector3f vector3f = blockPos.getCenter().toVector3f();
        if (face != null) {
            vector3f = vector3f.add((Vector3fc)face.step().div((Vector3fc)new Vector3f(2.0f, 2.0f, 2.0f)));
        }
        for (int i = 0; i <= randomSource.nextIntBetweenInclusive(5, 10); ++i) {
            level.addParticle((ParticleOptions)new DustParticleOptions(dye.isEmpty() ? Vec3.fromRGB24((int)0xD5D5D5).toVector3f() : Vec3.fromRGB24((int)Dye.colorForDye(this, dye.color())).toVector3f(), 1.0f), (double)vector3f.x + randomSource.nextDouble() - 0.5, (double)vector3f.y + randomSource.nextDouble() - 0.5, (double)vector3f.z + randomSource.nextDouble() - 0.5, 0.0, 0.0, 0.0);
        }
    }

    default public Map<DyeColor, Integer> colorValues() {
        return (Map)Util.make((Object)Maps.newLinkedHashMap(), map -> Arrays.stream(DyeColor.values()).forEach(color -> map.put(color, color.getTextColor())));
    }

    public static List<DyeColor> vanillaDyeColors() {
        ArrayList<DyeColor> list = new ArrayList<DyeColor>();
        list.add(DyeColor.WHITE);
        list.add(DyeColor.ORANGE);
        list.add(DyeColor.MAGENTA);
        list.add(DyeColor.LIGHT_BLUE);
        list.add(DyeColor.YELLOW);
        list.add(DyeColor.LIME);
        list.add(DyeColor.PINK);
        list.add(DyeColor.GRAY);
        list.add(DyeColor.LIGHT_GRAY);
        list.add(DyeColor.CYAN);
        list.add(DyeColor.PURPLE);
        list.add(DyeColor.BLUE);
        list.add(DyeColor.BROWN);
        list.add(DyeColor.GREEN);
        list.add(DyeColor.RED);
        list.add(DyeColor.BLACK);
        return list;
    }

    public static boolean isModdedDye(DyeColor dyeColor) {
        return !Colorable.vanillaDyeColors().contains(dyeColor);
    }
}

