/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.compat.jei.corruption;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.abraxator.moresnifferflowers.data.datamaps.Corruptable;
import net.abraxator.moresnifferflowers.data.datamaps.ModDataMaps;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public record CorruptionRecipe(ItemStack source, ItemStack corrupted, int chance) {
    public static List<CorruptionRecipe> createRecipes() {
        ArrayList<CorruptionRecipe> recipes = new ArrayList<CorruptionRecipe>();
        for (Map.Entry entry : BuiltInRegistries.BLOCK.getDataMap(ModDataMaps.CORRUPTABLE).entrySet()) {
            Item source = ((Block)BuiltInRegistries.BLOCK.get((ResourceKey)entry.getKey())).asItem();
            int totalWeight = 0;
            for (Pair<Block, Integer> pair : ((Corruptable)entry.getValue()).list()) {
                totalWeight += ((Integer)pair.getSecond()).intValue();
            }
            for (Pair<Block, Integer> pair : ((Corruptable)entry.getValue()).list()) {
                int weight = (Integer)pair.getSecond();
                float percentage = (float)weight / (float)totalWeight * 100.0f;
                recipes.add(new CorruptionRecipe(source.getDefaultInstance(), ((Block)pair.getFirst()).asItem().getDefaultInstance(), (int)percentage));
            }
        }
        for (Map.Entry<Object, Object> entry : Corruptable.HARDCODED_BLOCK.entrySet()) {
            if (entry.getKey() == ModBlocks.AMBUSH_BOTTOM.get()) {
                recipes.add(new CorruptionRecipe(ModItems.AMBUSH_SEEDS.toStack(), ModItems.GARBUSH_SEEDS.toStack(), 100));
            } else if (entry.getKey() == ModBlocks.AMBUSH_TOP.get()) continue;
            recipes.add(new CorruptionRecipe(((Block)entry.getKey()).asItem().getDefaultInstance(), ((Block)entry.getValue()).asItem().getDefaultInstance(), 100));
        }
        return recipes;
    }
}

