/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.client.model.ModModelLayerLocations;
import net.abraxator.moresnifferflowers.client.model.entity.SaltBubbleModel;
import net.abraxator.moresnifferflowers.client.renderer.entity.CoolProjectileRenderer;
import net.abraxator.moresnifferflowers.entities.SaltBubbleProjectile;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class SaltBubbleRenderer
extends EntityRenderer<SaltBubbleProjectile> {
    private final SaltBubbleModel model;
    public static final ResourceLocation TEXTURE_SALT = MoreSnifferFlowers.loc("textures/entity/salt_bubble.png");
    public static final ResourceLocation TEXTURE_SOUR = MoreSnifferFlowers.loc("textures/entity/sour_bubble.png");

    public SaltBubbleRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new SaltBubbleModel(context.bakeLayer(ModModelLayerLocations.SALT_BUBBLE));
    }

    public void render(SaltBubbleProjectile entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (CoolProjectileRenderer.projectileCameraCheck((Entity)entity, this.entityRenderDispatcher)) {
            poseStack.pushPose();
            poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTick, (float)entity.yRotO, (float)entity.getYRot())));
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)partialTick, (float)entity.xRotO, (float)entity.getXRot())));
            poseStack.translate(0.0, -1.0, 0.0);
            float scale = 1.0f;
            float randomOffset = (float)(entity.position().x + entity.position().y + entity.position().z) * 10.0f;
            float time = ((float)entity.tickCount + randomOffset + partialTick) / 20.0f;
            float scaleAmount = entity.getState() == 1 ? 0.4f : 0.3f;
            scale = 1.1f + scaleAmount * Mth.sin((float)(time / 2.0f * ((float)Math.PI * 2)));
            poseStack.translate(0.0, (double)(-scale) + 1.1, 0.0);
            if (entity.getState() == 1) {
                poseStack.translate(0.0f, 0.2f * Mth.sin((float)(time / 4.0f * ((float)Math.PI * 2))), 0.0f);
            }
            if (entity.getState() == 2) {
                scale *= 2.0f;
            }
            poseStack.scale(scale, scale, scale);
            this.model.renderToBuffer(poseStack, buffer.getBuffer(this.model.renderType(this.getTextureLocation(entity))), packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
            super.render((Entity)entity, entityYaw, partialTick, poseStack, buffer, packedLight);
        }
    }

    public ResourceLocation getTextureLocation(SaltBubbleProjectile entity) {
        return entity.isCorrupted() ? TEXTURE_SOUR : TEXTURE_SALT;
    }
}

