/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.blockentities.DyespriaPlantBlockEntity;
import net.abraxator.moresnifferflowers.client.ModColorHandler;
import net.abraxator.moresnifferflowers.client.model.ModModelLayerLocations;
import net.abraxator.moresnifferflowers.components.Colorable;
import net.abraxator.moresnifferflowers.components.Dye;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DyespriaPlantBlockEntityRenderer
implements BlockEntityRenderer<DyespriaPlantBlockEntity> {
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final ModelPart modelPart;

    public DyespriaPlantBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderDispatcher = context.getEntityRenderer();
        this.modelPart = context.bakeLayer(ModModelLayerLocations.DYESPRIA);
    }

    public void render(DyespriaPlantBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        boolean hasDye;
        BlockState state = blockEntity.getBlockState();
        boolean isGrown = (Integer)state.getValue((Property)ModStateProperties.AGE_3) >= 3;
        Dye dye = blockEntity.dye;
        boolean bl = hasDye = !dye.isEmpty();
        if (isGrown) {
            boolean isModdedDye = Colorable.isModdedDye(dye.color());
            boolean hasInvalidDye = dye.isEmpty() || isModdedDye;
            String colorName = hasInvalidDye ? "white" : dye.color().getName();
            Material TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, MoreSnifferFlowers.loc("block/dyespria/dyespria_top_" + colorName));
            poseStack.pushPose();
            poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            poseStack.translate(0.5, -1.5, -0.5);
            if (DyespriaPlantBlockEntityRenderer.isRotated(blockEntity.getBlockPos())) {
                poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
            }
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            if (isModdedDye) {
                float[] rgb = ModColorHandler.hexToRGB(dye.color().getTextColor());
                r = rgb[0];
                g = rgb[1];
                b = rgb[2];
            }
            this.modelPart.render(poseStack, TEXTURE.buffer(buffer, RenderType::entityCutout), packedLight, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.colorFromFloat((float)1.0f, (float)r, (float)g, (float)b));
            poseStack.popPose();
        }
        if (isGrown && hasDye && !((Boolean)state.getValue((Property)ModStateProperties.SHEARED)).booleanValue()) {
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            DyeItem dyeItem = DyeItem.byColor((DyeColor)((DyeColor)state.getValue(ModStateProperties.COLOR)));
            poseStack.pushPose();
            poseStack.translate(0.5, 0.9375, 0.5);
            poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
            poseStack.scale(0.35f, 0.35f, 0.35f);
            itemRenderer.renderStatic(new ItemStack((ItemLike)dyeItem), ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, blockEntity.getLevel(), (int)blockEntity.getBlockPos().asLong());
            poseStack.popPose();
        }
    }

    public static boolean isRotated(BlockPos pos) {
        long total = pos.getX() + pos.getY() + pos.getZ();
        return total % 2L == 0L;
    }
}

