/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.gui.screen.cookbook;

import net.abraxator.moresnifferflowers.capability.NutritionCapability;
import net.abraxator.moresnifferflowers.client.gui.screen.cookbook.CookbookScreen;
import net.abraxator.moresnifferflowers.init.ModDataAttachments;
import net.abraxator.moresnifferflowers.nutrition.NutritionType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.world.effect.MobEffect;

public class EffectWidget
extends AbstractWidget {
    private final NutritionType nutrition;
    private final CookbookScreen screen;
    private final boolean isPositive;

    public EffectWidget(int x, int y, Component message, NutritionType nutrition, CookbookScreen screen, boolean isPositive) {
        super(x, y, 20, 20, message);
        this.nutrition = nutrition;
        this.screen = screen;
        this.isPositive = isPositive;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        MobEffectTextureManager mobeffecttexturemanager = Minecraft.getInstance().getMobEffectTextures();
        int id = NutritionCapability.idFromNutrition(this.nutrition, this.isPositive);
        NutritionCapability capability = (NutritionCapability)Minecraft.getInstance().player.getData(ModDataAttachments.NUTRITION);
        boolean isUnlocked = capability.unlockedEffects.contains(id);
        int size = isUnlocked ? 18 : 21;
        Holder<MobEffect> effect = NutritionCapability.effectFromId(id);
        if (isUnlocked) {
            guiGraphics.blit(this.getX(), this.getY(), 0, size, size, mobeffecttexturemanager.get(effect));
        } else {
            guiGraphics.blit(CookbookScreen.RENDERABLES, this.getX(), this.getY(), 0, 32, size, size);
        }
        guiGraphics.blit(CookbookScreen.RENDERABLES, this.getX() - 10, this.getY() - 2, 0, 160, 118, 22);
        String text = this.isPositive ? Component.translatable((String)"gui.moresnifferflowers.cookbook.positive").getString() : Component.translatable((String)"gui.moresnifferflowers.cookbook.negative").getString();
        int color = this.isPositive ? 6787356 : 9251362;
        guiGraphics.drawWordWrap(this.screen.getMinecraft().font, FormattedText.of((String)text, (Style)Style.EMPTY.withBold(Boolean.valueOf(true)).withUnderlined(Boolean.valueOf(true))), this.getX() + 35, this.getY() + 4, 100, color);
        if (this.isHovered && isUnlocked) {
            this.screen.renderEffectInfo(guiGraphics, (MobEffect)effect.value(), this.isPositive);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

