/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.gui.screen;

import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.client.gui.screen.DyespriaTooltip;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientDyespriaTooltip
implements ClientTooltipComponent {
    public static final ResourceLocation TEXTURE = MoreSnifferFlowers.loc("textures/gui/dyespria_tooltip.png");
    ItemStack stack;
    boolean isPatternspria;
    int dyespriaMode;

    public ClientDyespriaTooltip(DyespriaTooltip dyespriaTooltip) {
        this.stack = dyespriaTooltip.stack;
        this.isPatternspria = dyespriaTooltip.isPatternspria;
        this.dyespriaMode = dyespriaTooltip.dyespriaMode;
    }

    public int getHeight() {
        return 26;
    }

    public int getWidth(Font font) {
        return 48;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        guiGraphics.blit(TEXTURE, x - 1, y - 1, 0, 0, 24, 24);
        int modeOffset = 64 + 16 * this.dyespriaMode;
        guiGraphics.blit(TEXTURE, x + 32, y + 3, modeOffset, 0, 16, 16);
        int stackXOffset = x + 3;
        int stackYOffset = y + 3;
        if (this.stack.isEmpty()) {
            int vOffset = this.isPatternspria ? 48 : 32;
            guiGraphics.blit(TEXTURE, stackXOffset, stackYOffset, vOffset, 0, 16, 16);
        } else {
            guiGraphics.renderItem(this.stack, stackXOffset, stackYOffset);
            guiGraphics.renderItemDecorations(font, this.stack, stackXOffset, stackYOffset, String.valueOf(this.stack.getCount()));
        }
    }
}

