/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.capability;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class UntouchableCapability {
    public static final ResourceLocation ID_SPEED = MoreSnifferFlowers.loc("untouchable_speed");
    public static final ResourceLocation ID_RESISTANCE = MoreSnifferFlowers.loc("untouchable_resistance");
    public double lastX = 0.0;
    public double lastZ = 0.0;
    public float speedModifier = 0.0f;
    public static final Codec<UntouchableCapability> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("lastX").forGetter(data -> data.lastX), (App)Codec.DOUBLE.fieldOf("lastZ").forGetter(data -> data.lastZ), (App)Codec.FLOAT.fieldOf("speedModifier").forGetter(data -> Float.valueOf(data.speedModifier))).apply((Applicative)instance, (a, b, c) -> {
        UntouchableCapability cap = new UntouchableCapability();
        cap.lastX = a;
        cap.lastZ = b;
        cap.speedModifier = c.floatValue();
        return cap;
    }));

    public void onAttacked() {
        this.speedModifier *= 0.7f;
    }

    public void onEffectEnd(Player player) {
        player.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(ID_SPEED);
        player.getAttribute(Attributes.ARMOR).removeModifier(ID_RESISTANCE);
        this.speedModifier = 0.0f;
    }

    public void tick(Player player, int amplifier) {
        Vec3 position = player.position();
        double posX = position.x;
        double posZ = position.z;
        if (this.lastX == 0.0 && this.lastZ == 0.0) {
            this.lastX = posX;
            this.lastZ = posZ;
            return;
        }
        float speedAccumulation = 5.0E-5f;
        float maxSpeed = 150 + amplifier * 15;
        speedAccumulation += speedAccumulation / 3.0f * (float)amplifier;
        double speedX = Math.abs(posX - this.lastX);
        double speedZ = Math.abs(posZ - this.lastZ);
        int speed = Math.round((float)(speedX * speedX + speedZ * speedZ) * 1000.0f);
        float armorModifier = Mth.floor((float)(this.speedModifier * 400.0f));
        if (armorModifier < 0.0f) {
            armorModifier = 0.0f;
        }
        if (player.isSprinting()) {
            if ((float)speed <= maxSpeed) {
                this.speedModifier += speedAccumulation;
            }
        } else if (this.speedModifier > 0.0f) {
            this.speedModifier -= speedAccumulation * 15.0f;
        }
        player.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(ID_SPEED);
        player.getAttribute(Attributes.ARMOR).removeModifier(ID_RESISTANCE);
        AttributeModifier mod = new AttributeModifier(ID_SPEED, (double)this.speedModifier, AttributeModifier.Operation.ADD_VALUE);
        AttributeModifier mod1 = new AttributeModifier(ID_RESISTANCE, (double)armorModifier, AttributeModifier.Operation.ADD_VALUE);
        player.getAttribute(Attributes.MOVEMENT_SPEED).addTransientModifier(mod);
        player.getAttribute(Attributes.ARMOR).addTransientModifier(mod1);
        this.lastX = posX;
        this.lastZ = posZ;
    }

    public void debugPrint(Level level) {
        System.out.println("Speed Modifier = " + this.speedModifier + " client = " + level.isClientSide());
    }
}

