/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks.cropressor;

import com.mojang.serialization.MapCodec;
import net.abraxator.moresnifferflowers.blockentities.CropressorBlockEntity;
import net.abraxator.moresnifferflowers.blocks.cropressor.CropressorBlockOut;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CropressorBlockBase
extends HorizontalDirectionalBlock {
    public final Part PART;
    protected static final VoxelShape OUT_EAST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final VoxelShape OUT_SOUTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final VoxelShape OUT_WEST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final VoxelShape OUT_NORTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final VoxelShape CENTER_EAST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final VoxelShape CENTER_SOUTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final VoxelShape CENTER_WEST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final VoxelShape CENTER_NORTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    public static final MapCodec<CropressorBlockBase> CODEC = CropressorBlockBase.simpleCodec(properties1 -> new CropressorBlockBase((BlockBehaviour.Properties)properties1, Part.CENTER));

    public CropressorBlockBase(BlockBehaviour.Properties properties, Part part) {
        super(properties);
        this.PART = part;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = CropressorBlockBase.getConnectedDirection(state);
        if (state.getBlock() instanceof CropressorBlockOut) {
            return switch (direction) {
                case Direction.EAST -> OUT_EAST;
                case Direction.SOUTH -> OUT_SOUTH;
                case Direction.WEST -> OUT_WEST;
                default -> OUT_NORTH;
            };
        }
        return switch (direction) {
            case Direction.EAST -> CENTER_EAST;
            case Direction.SOUTH -> CENTER_SOUTH;
            case Direction.WEST -> CENTER_WEST;
            default -> CENTER_NORTH;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ModStateProperties.FULLNESS});
    }

    private Direction getNeighbourDirection(Part part, Direction direction) {
        return part == Part.OUT ? direction : direction.getOpposite();
    }

    public BlockState updateShape(BlockState state, Direction pDirection, BlockState pNeighborState, LevelAccessor level, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (pDirection == this.getNeighbourDirection(this.PART, (Direction)state.getValue((Property)FACING))) {
            boolean b1;
            boolean b = pNeighborState.getBlock() instanceof CropressorBlockBase;
            boolean bl = b1 = CropressorBlockBase.getPartFromState(pNeighborState) != this.PART;
            if (b && b1) {
                return super.updateShape(state, pDirection, pNeighborState, level, pCurrentPos, pNeighborPos);
            }
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, pDirection, pNeighborState, level, pCurrentPos, pNeighborPos);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return ((Item)ModItems.CROPRESSOR.get()).getDefaultInstance();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        BlockPos blockPos = context.getClickedPos();
        BlockPos blockPos1 = blockPos.relative(direction);
        Level level = context.getLevel();
        return level.getBlockState(blockPos1).canBeReplaced(context) && level.getWorldBorder().isWithinBounds(blockPos1) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction) : null;
    }

    public static Direction getConnectedDirection(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return CropressorBlockBase.getPartFromState(state) == Part.CENTER ? direction.getOpposite() : direction;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity pPlacer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, pPlacer, stack);
        if (!level.isClientSide) {
            BlockPos blockPos = pos.relative((Direction)state.getValue((Property)FACING));
            level.setBlock(blockPos, (BlockState)((Block)ModBlocks.CROPRESSOR_CENTER.get()).defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))), 3);
            level.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        CropressorBlockEntity entity;
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(CropressorBlockBase.getEntityPos((BlockAndTintGetter)level, pos, this.PART))) instanceof CropressorBlockEntity && (entity = (CropressorBlockEntity)blockEntity).canInteract() && player.getMainHandItem().is(ModTags.ModItemTags.CROPRESSABLE)) {
            return entity.addItem(player.getItemInHand(hand));
        }
        return ItemInteractionResult.FAIL;
    }

    @NotNull
    public static BlockPos getEntityPos(BlockAndTintGetter level, BlockPos blockPos, Part part) {
        if (part == Part.OUT) {
            return blockPos;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!(level.getBlockEntity(blockPos.relative(direction)) instanceof CropressorBlockEntity)) continue;
            return blockPos.relative(direction);
        }
        return null;
    }

    public static Part getPartFromState(BlockState blockState) {
        Part part;
        Block block = blockState.getBlock();
        if (block instanceof CropressorBlockBase) {
            CropressorBlockBase baseCropressorBlock = (CropressorBlockBase)block;
            part = baseCropressorBlock.PART;
        } else {
            part = null;
        }
        return part;
    }

    public static enum Part implements StringRepresentable
    {
        CENTER("center"),
        OUT("out");

        public static final StringRepresentable.EnumCodec<DyeColor> CODEC;
        private String name;

        private Part(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(DyeColor::values);
        }
    }
}

