/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import com.mojang.serialization.MapCodec;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.blocks.TorchflowerAflameBlock;
import net.abraxator.moresnifferflowers.init.ModEffects;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TorchewflowerBlock
extends BushBlock
implements ModCropBlock {
    public static final MapCodec<TorchewflowerBlock> CODEC = TorchewflowerBlock.simpleCodec(TorchewflowerBlock::new);

    public TorchewflowerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.getAgeProperty()});
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return ModStateProperties.AGE_3;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
        if (this.getAge(state) == this.getMaxAge()) {
            TorchewflowerBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)((Item)ModItems.SWEET_SPICE.get()).getDefaultInstance());
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.isValidBonemealTarget((LevelReader)level, pos, state)) {
            this.makeGrowOnTick(state, (Level)level, pos);
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        int age = this.getAge(state);
        return age < 2;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.entityInside(state, level, pos, entity);
        if (this.getAge(state) == 2 && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.addEffect(new MobEffectInstance(ModEffects.GLUED, 100, 0));
            level.setBlock(pos, (BlockState)state.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getMaxAge())), 3);
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (this.isMaxAge(state)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)), 3);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.getOffset(level, pos);
        return TorchflowerAflameBlock.SHAPE.move(vec3.x, vec3.y, vec3.z);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        int age = this.getAge(state);
        return age < 2;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return TorchflowerAflameBlock.isBonemealSuccess(level);
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.setBlock(pos, (BlockState)state.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getAge(state) + 1)), 3);
    }
}

