/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import net.abraxator.moresnifferflowers.entities.SaltProjectile;
import net.abraxator.moresnifferflowers.init.ModEffects;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SourPuddleBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public SourPuddleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PipeBlock.NORTH, (Comparable)Boolean.FALSE)).setValue((Property)PipeBlock.EAST, (Comparable)Boolean.FALSE)).setValue((Property)PipeBlock.WEST, (Comparable)Boolean.FALSE)).setValue((Property)PipeBlock.SOUTH, (Comparable)Boolean.FALSE)).setValue((Property)ModStateProperties.FULL, (Comparable)Boolean.FALSE)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level blockgetter = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)PipeBlock.NORTH, (Comparable)Boolean.valueOf(this.connectsTo((BlockGetter)blockgetter, blockpos, Direction.NORTH)))).setValue((Property)PipeBlock.EAST, (Comparable)Boolean.valueOf(this.connectsTo((BlockGetter)blockgetter, blockpos, Direction.EAST)))).setValue((Property)PipeBlock.SOUTH, (Comparable)Boolean.valueOf(this.connectsTo((BlockGetter)blockgetter, blockpos, Direction.SOUTH)))).setValue((Property)PipeBlock.WEST, (Comparable)Boolean.valueOf(this.connectsTo((BlockGetter)blockgetter, blockpos, Direction.WEST)))).setValue((Property)ModStateProperties.FULL, (Comparable)Boolean.valueOf(this.isFull((BlockGetter)blockgetter, blockpos)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean connectsTo(BlockGetter level, BlockPos pos, Direction direction) {
        BlockPos pos1 = pos.offset(direction.getNormal());
        BlockState state = level.getBlockState(pos1);
        return state.is((Block)this);
    }

    public boolean isFull(BlockGetter level, BlockPos pos) {
        return Direction.Plane.HORIZONTAL.stream().allMatch(direction -> this.connectsTo(level, pos, (Direction)direction));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockState newState;
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        boolean isThis = facingState.is((Block)this);
        switch (facing) {
            default: {
                throw new MatchException(null, null);
            }
            case UP: 
            case DOWN: {
                BlockState blockState = state;
                break;
            }
            case NORTH: {
                BlockState blockState = (BlockState)state.setValue((Property)PipeBlock.NORTH, (Comparable)Boolean.valueOf(isThis));
                break;
            }
            case SOUTH: {
                BlockState blockState = (BlockState)state.setValue((Property)PipeBlock.SOUTH, (Comparable)Boolean.valueOf(isThis));
                break;
            }
            case EAST: {
                BlockState blockState = (BlockState)state.setValue((Property)PipeBlock.EAST, (Comparable)Boolean.valueOf(isThis));
                break;
            }
            case WEST: {
                BlockState blockState = newState = (BlockState)state.setValue((Property)PipeBlock.WEST, (Comparable)Boolean.valueOf(isThis));
            }
        }
        if (((Boolean)newState.getValue((Property)PipeBlock.WEST)).booleanValue() && ((Boolean)newState.getValue((Property)PipeBlock.EAST)).booleanValue() && ((Boolean)newState.getValue((Property)PipeBlock.NORTH)).booleanValue() && ((Boolean)newState.getValue((Property)PipeBlock.SOUTH)).booleanValue()) {
            return super.updateShape((BlockState)newState.setValue((Property)ModStateProperties.FULL, (Comparable)Boolean.valueOf(true)), facing, facingState, level, currentPos, facingPos);
        }
        if (this.isFree(level.getBlockState(currentPos.below())) && currentPos.getY() >= level.getMinBuildHeight()) {
            level.setBlock(currentPos, Blocks.AIR.defaultBlockState(), 3);
            SaltProjectile projectile = new SaltProjectile((Level)level);
            projectile.setCorrupted(true);
            projectile.setPos(currentPos.below().getCenter());
            projectile.setXRot((float)Math.PI / 90);
            level.addFreshEntity((Entity)projectile);
            return Blocks.AIR.defaultBlockState();
        }
        if (!this.canSurvive(state, (LevelReader)level, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape((BlockState)newState.setValue((Property)ModStateProperties.FULL, (Comparable)Boolean.valueOf(false)), facing, facingState, level, currentPos, facingPos);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.entityInside(state, level, pos, entity);
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            player.addEffect(new MobEffectInstance(ModEffects.SLIPPERY, 40, 5));
        }
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean isFree(BlockState state) {
        return state.isAir() || state.is(BlockTags.FIRE) || state.liquid() || state.canBeReplaced();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PipeBlock.NORTH, PipeBlock.EAST, PipeBlock.WEST, PipeBlock.SOUTH, ModStateProperties.FULL, WATERLOGGED});
    }
}

