/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import net.abraxator.moresnifferflowers.blockentities.ModCauldronBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ModLayeredCauldronBlock
extends LayeredCauldronBlock
implements EntityBlock {
    public ModLayeredCauldronBlock(Biome.Precipitation precipitationType, CauldronInteraction.InteractionMap interactions, BlockBehaviour.Properties properties) {
        super(precipitationType, interactions, properties);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return ModCauldronBlockEntity.getItemstack((BlockGetter)level, pos);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ModCauldronBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!newState.is(state.getBlock()) && !newState.is(BlockTags.CAULDRONS) && (blockEntity = level.getBlockEntity(pos)) instanceof ModCauldronBlockEntity) {
            ModCauldronBlockEntity entity = (ModCauldronBlockEntity)blockEntity;
            ItemStack cauldronItem = entity.getItemstack();
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)cauldronItem);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ModCauldronBlockEntity) {
            ModCauldronBlockEntity entity = (ModCauldronBlockEntity)blockEntity;
            if (oldState.is(BlockTags.CAULDRONS) && !oldState.is((Block)this)) {
                entity.originalCauldron = oldState;
            }
        }
        super.onPlace(state, level, pos, oldState, movedByPiston);
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ModCauldronBlockEntity) {
            ModCauldronBlockEntity entity = (ModCauldronBlockEntity)blockEntity;
            super.spawnDestroyParticles(level, player, pos, entity.originalCauldron);
            return;
        }
        super.spawnDestroyParticles(level, player, pos, state);
    }
}

