/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import net.abraxator.moresnifferflowers.blocks.DawnberryVineBlock;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class GloomberryVineBlock
extends DawnberryVineBlock {
    public GloomberryVineBlock(BlockBehaviour.Properties properties) {
        super(properties, true);
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity pEntity) {
        if (pEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)pEntity;
            livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 30, 0));
        }
    }

    @Override
    protected InteractionResult dropAgeThreeLoot(BlockState blockState, Level level, BlockPos pos, Player player) {
        ItemStack DAWNBERRY = new ItemStack((ItemLike)ModItems.GLOOMBERRY.get());
        GloomberryVineBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)DAWNBERRY);
        level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
        BlockState state = (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(2));
        level.setBlock(pos, state, 2);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

