/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import java.util.List;
import net.abraxator.moresnifferflowers.blockentities.BoblingSackBlockEntity;
import net.abraxator.moresnifferflowers.blocks.ModEntityBlock;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BoblingSackBlock
extends Block
implements ModEntityBlock {
    public static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);

    public BoblingSackBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public static void spawnSack(ServerLevel serverLevel, BlockPos pos, List<ItemStack> drops) {
        serverLevel.setBlockAndUpdate(pos, ((Block)ModBlocks.BOBLING_SACK.get()).defaultBlockState());
        BlockEntity blockEntity = serverLevel.getBlockEntity(pos);
        if (blockEntity instanceof BoblingSackBlockEntity) {
            BoblingSackBlockEntity boblingEntity = (BoblingSackBlockEntity)blockEntity;
            boblingEntity.inventory = NonNullList.withSize((int)drops.size(), (Object)ItemStack.EMPTY);
            for (int i = 0; i < drops.size(); ++i) {
                boblingEntity.inventory.set(i, (Object)drops.get(i));
            }
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pMovedByPiston) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BoblingSackBlockEntity) {
            BoblingSackBlockEntity entity = (BoblingSackBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, entity.inventory);
        }
        super.onRemove(state, level, pos, pNewState, pMovedByPiston);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BoblingSackBlockEntity(pos, state);
    }
}

