/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blockentities;

import net.abraxator.moresnifferflowers.blockentities.IModBlockEntity;
import net.abraxator.moresnifferflowers.blocks.SaltemoneBlock;
import net.abraxator.moresnifferflowers.entities.SaltBubbleProjectile;
import net.abraxator.moresnifferflowers.init.ModBlockEntities;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.networking.toClient.SaltemoneParticlePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.nikdo53.tinymultiblocklib.blockentities.AbstractMultiBlockEntity;

public class SaltemoneBlockEntity
extends AbstractMultiBlockEntity
implements IModBlockEntity {
    public int bubbleCount = 0;
    public static final int MAX_BUBBLE_COUNT = 5;

    public SaltemoneBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SALTEMONE.get(), pos, state);
    }

    @Override
    public void tick(Level level) {
        if (this.getLevel() == null) {
            return;
        }
        BlockState state = this.getBlockState();
        SaltemoneBlock saltemoneBlock = (SaltemoneBlock)state.getBlock();
        RandomSource random = this.getLevel().getRandom();
        if (!this.canSpawnBubble(state, random, saltemoneBlock)) {
            return;
        }
        Direction direction = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        Vec3 vec3 = this.getCenter().getCenter().relative(direction, 0.5).relative(direction.getClockWise(), 0.5).relative(Direction.UP, 0.0);
        float speed = 0.2f;
        SaltBubbleProjectile projectile = new SaltBubbleProjectile(vec3.x, vec3.y, vec3.z, level, this.getCenter());
        projectile.setNoGravity(true);
        projectile.setCorrupted(saltemoneBlock.isCorrupted());
        projectile.setState(0);
        projectile.setDeltaMovement(((double)random.nextFloat() - 0.5) * (double)speed, 1.0f * speed, ((double)random.nextFloat() - 0.5) * (double)speed);
        this.getLevel().addFreshEntity((Entity)projectile);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SaltemoneParticlePacket(vec3.toVector3f()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ++this.bubbleCount;
        this.setChanged();
    }

    private boolean canSpawnBubble(BlockState state, RandomSource random, SaltemoneBlock saltemoneBlock) {
        if (((Boolean)state.getValue((Property)ModStateProperties.SHEARED)).booleanValue()) {
            return false;
        }
        if (this.bubbleCount >= 5) {
            return false;
        }
        if (this.getLevel().getGameTime() % 160L != 0L || !(random.nextFloat() < 0.2f)) {
            return false;
        }
        if (!this.isCenter()) {
            return false;
        }
        return saltemoneBlock.isMaxAge(state);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.isCenter()) {
            tag.putInt("bubbleCount", this.bubbleCount);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (this.isCenter()) {
            this.bubbleCount = tag.getInt("bubbleCount");
            this.bubbleCount = Math.clamp((long)this.bubbleCount, 0, 5);
        }
    }
}

