/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blockentities;

import net.abraxator.moresnifferflowers.init.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ModCauldronBlockEntity
extends BlockEntity {
    public BlockState originalCauldron = Blocks.CAULDRON.defaultBlockState();

    public ModCauldronBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.MOD_CAULDRON.get(), pos, blockState);
    }

    public ItemStack getItemstack() {
        return ((Item)Item.BY_BLOCK.get(this.originalCauldron.getBlock())).getDefaultInstance();
    }

    public static ItemStack getItemstack(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ModCauldronBlockEntity) {
            ModCauldronBlockEntity blockEntity2 = (ModCauldronBlockEntity)blockEntity;
            return blockEntity2.getItemstack();
        }
        return ItemStack.EMPTY;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putString("cauldron", BuiltInRegistries.BLOCK.getKey((Object)this.originalCauldron.getBlock()).toString());
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.originalCauldron = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)tag.getString("cauldron")))).defaultBlockState();
        if (this.originalCauldron.isAir()) {
            this.originalCauldron = Blocks.CAULDRON.defaultBlockState();
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

