/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blockentities;

import net.abraxator.moresnifferflowers.blockentities.ModBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class GrowingCropBlockEntity
extends ModBlockEntity {
    public float growProgress;
    public boolean hasGrown;
    public final float growRate;

    public GrowingCropBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, float growRate) {
        super(type, pos, state);
        this.growRate = growRate;
    }

    public void setChanged() {
        super.setChanged();
    }

    @Override
    public void tick(Level level) {
        if (this.canGrow(this.growProgress, this.hasGrown)) {
            this.growProgress += this.growRate;
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
            if (this.growProgress >= 1.0f) {
                this.onGrow(this.getBlockPos(), this.getBlockState(), this.getLevel());
            }
        }
    }

    public boolean canGrow(float growProgress, boolean hasGrown) {
        return !(growProgress >= 1.0f) && !hasGrown;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void onGrow(BlockPos blockPos, BlockState state, Level level) {
        this.hasGrown = true;
        this.level.sendBlockUpdated(blockPos, state, state, 2);
    }

    public void reset() {
        this.growProgress = 0.0f;
        this.hasGrown = false;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.hasGrown = tag.getBoolean("hasGrown");
        this.growProgress = tag.getFloat("progress");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("hasGrown", this.hasGrown);
        tag.putFloat("progress", this.growProgress);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

