/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blockentities;

import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import net.abraxator.moresnifferflowers.blockentities.ModBlockEntity;
import net.abraxator.moresnifferflowers.blocks.cropressor.CropressorBlockBase;
import net.abraxator.moresnifferflowers.client.ModColorHandler;
import net.abraxator.moresnifferflowers.components.BetterNonNullList;
import net.abraxator.moresnifferflowers.init.ModBlockEntities;
import net.abraxator.moresnifferflowers.init.ModRecipeTypes;
import net.abraxator.moresnifferflowers.init.ModSoundEvents;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.abraxator.moresnifferflowers.recipes.CropressingRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CropressorBlockEntity
extends ModBlockEntity
implements Container {
    public static int SLOT_SIZE = 9;
    public BetterNonNullList<ItemStack> container = BetterNonNullList.withSize(SLOT_SIZE, ItemStack.EMPTY);
    public ItemStack currentCrop = ItemStack.EMPTY;
    public ItemStack result = ItemStack.EMPTY;
    public int progress = 0;
    public final int MAX_PROGRESS = 100;
    private static final int INV_SIZE = 16;
    private final RecipeManager.CachedCheck<SingleRecipeInput, CropressingRecipe> quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)ModRecipeTypes.CROPRESSING.get()));
    public int barLength = 0;

    public CropressorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CROPRESSOR.get(), pos, state);
    }

    @Override
    public void tick(Level level) {
        long gameTime = level.getGameTime();
        if (this.progress > 0 && gameTime % 3L == 0L) {
            ++this.progress;
            if (this.progress % 20 == 0) {
                level.playSound(null, this.worldPosition, (SoundEvent)ModSoundEvents.CROPRESSOR_BELT.get(), SoundSource.BLOCKS, 1.0f, (float)(1.0 + (double)level.getRandom().nextFloat() * 0.2));
            }
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
            if (this.progress >= 100) {
                Vec3 blockPos = this.getBlockPos().relative(((Direction)this.getBlockState().getValue((Property)CropressorBlockBase.FACING)).getOpposite()).getCenter();
                ItemEntity entity = new ItemEntity(level, blockPos.x, blockPos.y + 0.5, blockPos.z, this.result);
                this.result = ItemStack.EMPTY;
                if (this.barLength >= 8) {
                    this.barLength = 0;
                }
                level.playSound(null, this.worldPosition, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.4f, 1.0f);
                level.addFreshEntity((Entity)entity);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of((BlockState)this.getBlockState()));
                this.progress = 0;
                this.setChanged();
            }
        }
        if (gameTime % 10L != 0L) {
            return;
        }
        if (gameTime % 20L == 0L) {
            this.suckInItems(level);
        }
        if (this.container.isFullyDefault()) {
            return;
        }
        if (this.progress <= 0) {
            for (int slot = 0; slot < SLOT_SIZE; ++slot) {
                ItemStack slotStack = (ItemStack)this.container.get(slot);
                if (slotStack.isEmpty()) continue;
                SingleRecipeInput recipeInput = new SingleRecipeInput(slotStack);
                Optional cropressingRecipeOptional = this.quickCheck.getRecipeFor((RecipeInput)recipeInput, level);
                cropressingRecipeOptional.ifPresent(recipeHolder -> {
                    CropressingRecipe recipe = (CropressingRecipe)recipeHolder.value();
                    if (slotStack.getCount() >= recipe.count()) {
                        this.result = recipe.result();
                        slotStack.shrink(recipe.count());
                    }
                });
                if (this.result.isEmpty()) continue;
                ++this.progress;
                this.currentCrop = slotStack;
                this.barLength = Math.min(Mth.ceil((float)((float)this.getTotalAmount(slotStack.getItem()) / 2.0f)), 8);
                this.setChanged();
                return;
            }
        }
    }

    public boolean canInteract() {
        return true;
    }

    public ItemInteractionResult addItem(ItemStack stack) {
        boolean success = false;
        ItemStack copy = stack.copy();
        if (stack.is(ModTags.ModItemTags.CROPRESSABLE)) {
            if (this.hasAnyOf(Set.of(stack.getItem()))) {
                for (int slot = 0; slot < SLOT_SIZE && !stack.isEmpty(); ++slot) {
                    ItemStack slotStack = (ItemStack)this.container.get(slot);
                    int space = 64 - slotStack.getCount();
                    if (!slotStack.is(stack.getItem()) || space <= 0) continue;
                    ItemStack split = stack.split(space);
                    slotStack.grow(split.getCount());
                    this.container.set(slot, slotStack);
                    success = true;
                }
            }
            if (!stack.isEmpty() && this.container.getValidSize() < SLOT_SIZE) {
                this.container.set(this.container.getFirstEmptySlot(), stack.copy());
                stack.shrink(stack.getCount());
                success = true;
            }
            if (success) {
                this.currentCrop = new ItemStack((ItemLike)copy.getItem(), this.getTotalAmount(copy.getItem()));
                this.barLength = Math.min(Mth.ceil((float)((float)this.getTotalAmount(copy.getItem()) / 2.0f)), 8);
                this.setChanged();
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public int getTotalAmount(Item item) {
        int amount = 0;
        for (int slot = 0; slot < SLOT_SIZE; ++slot) {
            ItemStack stack = (ItemStack)this.container.get(slot);
            if (!stack.is(item)) continue;
            amount += stack.getCount();
        }
        return amount;
    }

    public void suckInItems(Level level) {
        Direction direction1;
        Direction direction = (Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
        BlockPos pos = this.worldPosition.relative(direction).above();
        Container container = HopperBlockEntity.getContainerAt((Level)level, (BlockPos)pos);
        if (container != null && !CropressorBlockEntity.isEmptyContainer(container, direction1 = Direction.DOWN)) {
            CropressorBlockEntity.getSlots(container, direction1).anyMatch(slot -> this.tryTakeInItemFromSlot(container, slot, direction1));
        }
    }

    private static boolean isEmptyContainer(Container container, Direction direction) {
        return CropressorBlockEntity.getSlots(container, direction).allMatch(slot -> container.getItem(slot).isEmpty());
    }

    private static IntStream getSlots(Container container, Direction direction) {
        return container instanceof WorldlyContainer ? IntStream.of(((WorldlyContainer)container).getSlotsForFace(direction)) : IntStream.range(0, container.getContainerSize());
    }

    private boolean tryTakeInItemFromSlot(Container container, int slot, Direction direction) {
        ItemStack originalStack = container.getItem(slot);
        if (!originalStack.isEmpty() && this.canTakeItemFromContainer(container, originalStack, slot, direction)) {
            ItemStack newStack = originalStack.copy();
            this.addItem(newStack);
            if (newStack.getCount() != originalStack.getCount()) {
                container.setChanged();
            }
            container.setItem(slot, newStack);
            return true;
        }
        return false;
    }

    private boolean canTakeItemFromContainer(Container destination, ItemStack itemStack, int slot, Direction direction) {
        return true;
    }

    public int getColor() {
        Item item = this.currentCrop.getItem();
        if (item.equals(Items.AIR)) {
            return 0;
        }
        if (item.equals(Items.POTATO)) {
            return 12094540;
        }
        if (item.equals(Items.CARROT)) {
            return 16752949;
        }
        if (item.equals(Items.NETHER_WART)) {
            return 10369323;
        }
        if (item.equals(Items.BEETROOT)) {
            return 12806246;
        }
        if (item.equals(Items.WHEAT)) {
            return 16773982;
        }
        int hash = item.toString().hashCode();
        double r = (hash & 0xFF0000) >> 16;
        double g = (hash & 0xFF00) >> 8;
        double b = hash & 0xFF;
        return ModColorHandler.RGBtoInt(new Vec3(r, g, b));
    }

    public int getContainerSize() {
        return SLOT_SIZE;
    }

    public boolean isEmpty() {
        return this.container.isFullyDefault();
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.container.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = (ItemStack)this.container.get(slot);
        this.setChanged();
        return stack.split(amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.container.setDefault(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.container.set(slot, stack);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.container.clear();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider reg) {
        super.saveAdditional(tag, reg);
        tag.put("content", this.currentCrop.saveOptional(reg));
        tag.putInt("progress", this.progress);
        tag.putInt("bar", this.barLength);
        tag.put("result", this.result.saveOptional(reg));
        CompoundTag slots = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)slots, this.container, (HolderLookup.Provider)reg);
        tag.put("slots", (Tag)slots);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider reg) {
        super.loadAdditional(tag, reg);
        this.currentCrop = ItemStack.parseOptional((HolderLookup.Provider)reg, (CompoundTag)tag.getCompound("content"));
        this.progress = tag.getInt("progress");
        this.barLength = tag.getInt("bar");
        this.result = ItemStack.parseOptional((HolderLookup.Provider)reg, (CompoundTag)tag.getCompound("result"));
        ContainerHelper.loadAllItems((CompoundTag)tag.getCompound("slots"), this.container, (HolderLookup.Provider)reg);
        ListTag containerTag = tag.getList("container", 10);
        for (int i = 0; i < SLOT_SIZE; ++i) {
            CompoundTag itemTag = containerTag.getCompound(i);
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)reg, (CompoundTag)itemTag);
            this.container.set(i, stack);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider reg) {
        CompoundTag compoundtag = new CompoundTag();
        this.saveAdditional(compoundtag, reg);
        return compoundtag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

