/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blockentities;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.abraxator.moresnifferflowers.blockentities.ModBlockEntity;
import net.abraxator.moresnifferflowers.blocks.Corruptable;
import net.abraxator.moresnifferflowers.entities.CorruptedProjectile;
import net.abraxator.moresnifferflowers.init.ModBlockEntities;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.abraxator.moresnifferflowers.init.config.ModServerConfig;
import net.abraxator.moresnifferflowers.networking.toClient.CorruptedSludgePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class CorruptedSludgeBlockEntity
extends ModBlockEntity
implements GameEventListener.Provider<CorruptedSludgeListener> {
    public CorruptedSludgeListener corruptedSludgeListener;
    public int usesLeft = -1;
    public int stateChange = 1;

    public CorruptedSludgeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CORRUPTED_SLUDGE.get(), pos, state);
        this.corruptedSludgeListener = new CorruptedSludgeListener((PositionSource)new BlockPositionSource(pos));
        this.stateChange = this.usesLeft / 4;
    }

    public void updateUses() {
        --this.usesLeft;
        if (this.stateChange == 0) {
            this.stateChange = this.usesLeft / 4;
        }
        if (this.usesLeft % this.stateChange == 0 && (Integer)this.getBlockState().getValue((Property)ModStateProperties.USES_4) - 1 != -1) {
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)ModStateProperties.USES_4, (Comparable)Integer.valueOf((Integer)this.getBlockState().getValue((Property)ModStateProperties.USES_4) - 1)));
        }
        if (this.usesLeft <= 0) {
            if (((Boolean)ModServerConfig.CORRUPTED_SLUDGE_GRIEFING.get()).booleanValue()) {
                CorruptedSludgeListener.shootProjectiles(this.getBlockPos().getCenter(), this.level.random.nextIntBetweenInclusive(8, 16), this.level);
            }
            super.setRemoved();
            this.level.setBlockAndUpdate(this.getBlockPos(), Blocks.AIR.defaultBlockState());
        }
    }

    public CorruptedSludgeListener getListener() {
        return this.corruptedSludgeListener;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("uses", this.usesLeft);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.usesLeft = tag.getInt("uses");
    }

    public static class CorruptedSludgeListener
    implements GameEventListener {
        private PositionSource positionSource;

        public CorruptedSludgeListener(PositionSource positionSource) {
            this.positionSource = positionSource;
        }

        public PositionSource getListenerSource() {
            return this.positionSource;
        }

        public int getListenerRadius() {
            return ((GameEvent)GameEvent.BLOCK_DESTROY.value()).notificationRadius();
        }

        public boolean handleGameEvent(ServerLevel level, Holder<GameEvent> pGameEvent, GameEvent.Context context, Vec3 pos) {
            Entity dirNormal2;
            boolean validEvent;
            CorruptedSludgeBlockEntity entity1;
            BlockEntity blockEntity = level.getBlockEntity(BlockPos.containing((Position)((Position)this.positionSource.getPosition((Level)level).get())));
            if (!(blockEntity instanceof CorruptedSludgeBlockEntity)) {
                return false;
            }
            CorruptedSludgeBlockEntity entity = entity1 = (CorruptedSludgeBlockEntity)blockEntity;
            boolean bl = validEvent = pGameEvent != GameEvent.BLOCK_PLACE || pGameEvent != GameEvent.BLOCK_DESTROY;
            if (entity.usesLeft == -1) {
                entity.usesLeft = level.random.nextIntBetweenInclusive(16, 32) - 1;
                entity.stateChange = entity.usesLeft / 4;
            }
            if (entity.usesLeft <= 0 || ((Boolean)entity.getBlockState().getValue((Property)ModStateProperties.CURED)).booleanValue() || !validEvent) {
                return false;
            }
            if (pGameEvent.is((Holder)GameEvent.BLOCK_PLACE) && net.abraxator.moresnifferflowers.data.datamaps.Corruptable.canBeCorrupted(context.affectedState().getBlock(), level.random)) {
                Vec3 startPos = (Vec3)this.getListenerSource().getPosition((Level)level).get();
                Vec3 dirNormal2 = new Vec3(pos.x - startPos.x, pos.y - startPos.y, pos.z - startPos.z).normalize();
                Optional<Block> corrupted = net.abraxator.moresnifferflowers.data.datamaps.Corruptable.getCorruptedBlock(context.affectedState().getBlock(), level.random);
                BlockPos blockPos = BlockPos.containing((Position)pos);
                corrupted.ifPresent(block -> {
                    PacketDistributor.sendToAllPlayers((CustomPacketPayload)new CorruptedSludgePacket(startPos.toVector3f(), pos.toVector3f(), dirNormal2.toVector3f()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    Block patt0$temp = level.getBlockState(BlockPos.containing((Position)pos)).getBlock();
                    if (patt0$temp instanceof Corruptable) {
                        Corruptable corruptable = (Corruptable)patt0$temp;
                        corruptable.onCorrupt((Level)level, blockPos, level.getBlockState(BlockPos.containing((Position)pos)), (Block)block);
                    } else {
                        level.setBlockAndUpdate(BlockPos.containing((Position)pos), block.withPropertiesOf(context.affectedState()));
                    }
                    level.sendParticles((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)4469320).toVector3f(), 1.0f), (double)blockPos.getX() + level.random.nextDouble(), (double)blockPos.getY() + level.random.nextDouble(), (double)blockPos.getZ() + level.random.nextDouble(), 10, 0.0, 0.0, 0.0, 0.0);
                    entity.updateUses();
                });
                return false;
            }
            if (((Boolean)ModServerConfig.CORRUPTED_SLUDGE_GRIEFING.get()).booleanValue() && pGameEvent.is((Holder)GameEvent.BLOCK_DESTROY) && context.affectedState().is(ModTags.ModBlockTags.CORRUPTED_SLUDGE) && !pos.equals(this.positionSource.getPosition((Level)level).get()) && (dirNormal2 = context.sourceEntity()) instanceof Player) {
                Player player = (Player)dirNormal2;
                int projectileNumber = context.affectedState().is(ModBlocks.CORRUPTED_LEAVES) || context.affectedState().is(ModBlocks.CORRUPTED_LEAVES_BUSH) ? level.random.nextInt(1) + 1 : level.random.nextInt(5) + 1;
                CorruptedSludgeListener.shootProjectiles((Vec3)this.positionSource.getPosition((Level)level).get(), projectileNumber, (Level)level);
                entity.updateUses();
                return false;
            }
            return false;
        }

        public static void shootProjectiles(Vec3 center, int projectileNumber, Level level) {
            double radius = 2.5;
            HashSet<Vec3> placed = new HashSet<Vec3>();
            for (int i = 0; i < projectileNumber; ++i) {
                CorruptedSludgeListener.generatePoint(placed, center, radius, level);
            }
        }

        private static void generatePoint(Set<Vec3> placed, Vec3 center, double radius, Level level) {
            RandomSource random = level.random;
            double theta = 6.2831854820251465 * random.nextDouble();
            double phi = Math.acos(2.0 * random.nextDouble() - 1.0);
            double xg = center.x + radius * (double)Mth.sin((float)((float)phi)) * (double)Mth.cos((float)((float)theta));
            double yg = center.y + radius * (double)Mth.sin((float)((float)phi)) * (double)Mth.sin((float)((float)theta));
            double zg = center.z + radius * (double)Mth.cos((float)((float)phi));
            Vec3 vec3 = new Vec3(xg, yg, zg);
            if (placed.stream().noneMatch(vec31 -> AABB.ofSize((Vec3)vec3, (double)1.0, (double)1.0, (double)1.0).contains(vec31)) && level.getBlockState(BlockPos.containing((Position)vec3)).canBeReplaced()) {
                Vec3 pos = center;
                double x = random.nextDouble() * 0.5;
                double y = random.nextDouble() * 0.5;
                double z = random.nextDouble() * 0.5;
                CorruptedProjectile projectile = new CorruptedProjectile(level);
                projectile.setPos(vec3);
                Vec3 dir = new Vec3(projectile.getX() - pos.x, projectile.getY() - pos.y, projectile.getZ() - pos.z).normalize().multiply(x, y, z);
                projectile.setDeltaMovement(dir);
                level.addFreshEntity((Entity)projectile);
                placed.add(vec3);
            }
        }
    }
}

