/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.Map;
import net.abraxator.moresnifferflowers.client.ClientRegistration;
import net.abraxator.moresnifferflowers.init.ModAdvancementCritters;
import net.abraxator.moresnifferflowers.init.ModBlockEntities;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModCauldronInteractions;
import net.abraxator.moresnifferflowers.init.ModCreativeTabs;
import net.abraxator.moresnifferflowers.init.ModDataAttachments;
import net.abraxator.moresnifferflowers.init.ModDataComponents;
import net.abraxator.moresnifferflowers.init.ModEffects;
import net.abraxator.moresnifferflowers.init.ModEntityDataSerializers;
import net.abraxator.moresnifferflowers.init.ModEntityTypes;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModLoot;
import net.abraxator.moresnifferflowers.init.ModLootModifiers;
import net.abraxator.moresnifferflowers.init.ModMenuTypes;
import net.abraxator.moresnifferflowers.init.ModPaintings;
import net.abraxator.moresnifferflowers.init.ModParticles;
import net.abraxator.moresnifferflowers.init.ModRecipeSerializers;
import net.abraxator.moresnifferflowers.init.ModRecipeTypes;
import net.abraxator.moresnifferflowers.init.ModSoundEvents;
import net.abraxator.moresnifferflowers.init.config.ModClientConfig;
import net.abraxator.moresnifferflowers.init.config.ModServerConfig;
import net.abraxator.moresnifferflowers.networking.ModPacketHandler;
import net.abraxator.moresnifferflowers.worldgen.configurations.ModTreeDecoratorTypes;
import net.abraxator.moresnifferflowers.worldgen.configurations.ModTrunkPlacerTypes;
import net.abraxator.moresnifferflowers.worldgen.feature.ModFeatures;
import net.abraxator.moresnifferflowers.worldgen.structures.ModStructureTypes;
import net.abraxator.moresnifferflowers.worldgen.structures.pieces.ModPieceTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import org.slf4j.Logger;

@Mod(value="moresnifferflowers")
public class MoreSnifferFlowers {
    public static final String MOD_ID = "moresnifferflowers";
    public static final Logger LOGGER = LogUtils.getLogger();

    public MoreSnifferFlowers(IEventBus modEventBus, Dist dist, ModContainer container) {
        if (dist.isClient()) {
            modEventBus.addListener(ClientRegistration::clientSetup);
            this.clientConfig(container);
        }
        modEventBus.addListener(this::commonSetup);
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ModServerConfig.SERVER_CONFIG);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModClientConfig.CLIENT_CONFIG);
        ModItems.ITEMS.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModLoot.CONDITIONS.register(modEventBus);
        ModFeatures.FEATURES.register(modEventBus);
        ModCreativeTabs.TABS.register(modEventBus);
        ModEffects.EFFECTS.register(modEventBus);
        ModSoundEvents.SOUNDS.register(modEventBus);
        ModPaintings.PAINTINGS.register(modEventBus);
        ModParticles.PARTICLES.register(modEventBus);
        ModMenuTypes.MENU_TYPES.register(modEventBus);
        ModEntityTypes.ENTITIES.register(modEventBus);
        ModTrunkPlacerTypes.TRUNKS.register(modEventBus);
        ModRecipeTypes.RECIPE_TYPES.register(modEventBus);
        ModPieceTypes.STRUCTURE_PIECE.register(modEventBus);
        ModAdvancementCritters.TRIGGERS.register(modEventBus);
        ModBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        ModLootModifiers.LOOT_MODIFIERS.register(modEventBus);
        ModTreeDecoratorTypes.DECORATORS.register(modEventBus);
        ModStructureTypes.STRUCTURE_PIECE.register(modEventBus);
        ModDataComponents.DATA_COMPONENTS.register(modEventBus);
        ModDataAttachments.ATTACHMENT_TYPES.register(modEventBus);
        ModEntityDataSerializers.SERIALIZERS.register(modEventBus);
        ModRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        ModPacketHandler.register(modEventBus, 1);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        AxeItem.STRIPPABLES = Maps.newHashMap((Map)AxeItem.STRIPPABLES);
        AxeItem.STRIPPABLES.put((Block)ModBlocks.CORRUPTED_LOG.get(), (Block)ModBlocks.STRIPPED_CORRUPTED_LOG.get());
        AxeItem.STRIPPABLES.put((Block)ModBlocks.VIVICUS_LOG.get(), (Block)ModBlocks.STRIPPED_VIVICUS_LOG.get());
        AxeItem.STRIPPABLES.put((Block)ModBlocks.CORRUPTED_WOOD.get(), (Block)ModBlocks.STRIPPED_CORRUPTED_WOOD.get());
        AxeItem.STRIPPABLES.put((Block)ModBlocks.VIVICUS_WOOD.get(), (Block)ModBlocks.STRIPPED_VIVICUS_WOOD.get());
        FlowerPotBlock pot = (FlowerPotBlock)Blocks.FLOWER_POT;
        pot.addPlant(ModBlocks.DYESPRIA_PLANT.getId(), ModBlocks.POTTED_DYESPRIA);
        pot.addPlant(ModBlocks.CORRUPTED_SAPLING.getId(), ModBlocks.POTTED_CORRUPTED_SAPLING);
        pot.addPlant(ModBlocks.VIVICUS_SAPLING.getId(), ModBlocks.POTTED_VIVICUS_SAPLING);
        FireBlock fireBlock = (FireBlock)Blocks.FIRE;
        fireBlock.setFlammable((Block)ModBlocks.CORRUPTED_LOG.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.CORRUPTED_WOOD.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.STRIPPED_CORRUPTED_LOG.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.STRIPPED_CORRUPTED_WOOD.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.CORRUPTED_PLANKS.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.CORRUPTED_STAIRS.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.CORRUPTED_SLAB.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.CORRUPTED_FENCE.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.CORRUPTED_FENCE_GATE.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.CORRUPTED_DOOR.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.CORRUPTED_TRAPDOOR.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.CORRUPTED_PRESSURE_PLATE.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.CORRUPTED_BUTTON.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.CORRUPTED_LEAVES.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.CORRUPTED_SAPLING.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.VIVICUS_LOG.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.VIVICUS_WOOD.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.STRIPPED_VIVICUS_LOG.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.STRIPPED_VIVICUS_WOOD.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.VIVICUS_PLANKS.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.VIVICUS_STAIRS.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.VIVICUS_SLAB.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.VIVICUS_FENCE.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.VIVICUS_FENCE_GATE.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.VIVICUS_DOOR.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.VIVICUS_TRAPDOOR.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.VIVICUS_PRESSURE_PLATE.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.VIVICUS_BUTTON.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.VIVICUS_LEAVES.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.VIVICUS_SAPLING.get(), 5, 20);
        fireBlock.setFlammable((Block)ModBlocks.VIVICUS_LEAVES_SPROUT.get(), 5, 20);
        ModCauldronInteractions.bootstrap();
    }

    public static boolean hasFarmersDelight() {
        return ModList.get().isLoaded("farmersdelight");
    }

    public static ResourceLocation farmersDelightLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)path);
    }

    public static ResourceLocation loc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public void clientConfig(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    public static ResourceLocation vanillaLoc(String path) {
        return ResourceLocation.withDefaultNamespace((String)path);
    }

    public static ResourceLocation ofLoc(String path) {
        return ResourceLocation.bySeparator((String)path, (char)':');
    }

    public static String sLoc(String path) {
        return MoreSnifferFlowers.loc(path).toString();
    }
}

