/*
 * Decompiled with CFR 0.152.
 */
package fuzs.magnumtorch.handler;

import fuzs.magnumtorch.MagnumTorch;
import fuzs.magnumtorch.attachment.TorchPositions;
import fuzs.magnumtorch.attachment.TypedBlockArea;
import fuzs.magnumtorch.config.ServerConfig;
import fuzs.magnumtorch.init.ModRegistry;
import fuzs.magnumtorch.world.level.block.MagnumTorchType;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class MobSpawningHandler {
    public static EventResult onEntityLoad(Entity entity, ServerLevel serverLevel, boolean isNewlySpawned) {
        Mob mob;
        block6: {
            block5: {
                if (!isNewlySpawned || !(entity instanceof Mob)) break block5;
                mob = (Mob)entity;
                if (MagnumTorch.CONFIG.getHolder(ServerConfig.class).isAvailable()) break block6;
            }
            return EventResult.PASS;
        }
        MobSpawnType entitySpawnReason = CommonAbstractions.INSTANCE.getMobSpawnType(mob);
        if (entitySpawnReason != null && entitySpawnReason != MobSpawnType.NATURAL) {
            MutableBoolean mutableBoolean = new MutableBoolean();
            MobSpawningHandler.preventSpawning(serverLevel, entity.blockPosition(), entitySpawnReason, type -> {
                if (type.getConfig().preventSpawning(entity.getType())) {
                    mutableBoolean.setTrue();
                    return true;
                }
                return false;
            });
            if (mutableBoolean.isTrue()) {
                MobSpawningHandler.removeEntitySafely(serverLevel, entity);
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    private static void removeEntitySafely(ServerLevel serverLevel, Entity entity) {
        List<Entity> entities = entity.getRootVehicle().getSelfAndPassengers().distinct().filter(passenger -> passenger != entity).toList();
        serverLevel.getServer().execute(() -> entities.forEach(Entity::discard));
    }

    public static void onGatherPotentialSpawns(ServerLevel serverLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, MobCategory mobCategory, BlockPos blockPos, List<MobSpawnSettings.SpawnerData> mobs) {
        if (mobs.isEmpty() || !MagnumTorch.CONFIG.getHolder(ServerConfig.class).isAvailable()) {
            return;
        }
        MobSpawningHandler.preventSpawning(serverLevel, blockPos, MobSpawnType.NATURAL, type -> {
            mobs.removeIf(spawnerData -> type.getConfig().preventSpawning(spawnerData.type));
            return false;
        });
    }

    private static void preventSpawning(ServerLevel serverLevel, BlockPos blockPos, MobSpawnType entitySpawnReason, Predicate<MagnumTorchType> spawnBlocker) {
        TorchPositions torchPositions = (TorchPositions)ModRegistry.TORCH_POSITIONS_ATTACHMENT_TYPE.getOrDefault((Object)serverLevel, (Object)TorchPositions.EMPTY);
        Collection<? extends TypedBlockArea> torchesInSection = torchPositions.getTorchesInSection(blockPos);
        if (!torchesInSection.isEmpty()) {
            EnumSet<MagnumTorchType> handledTypes = EnumSet.noneOf(MagnumTorchType.class);
            for (TypedBlockArea typedBlockArea : torchesInSection) {
                MagnumTorchType type = typedBlockArea.type();
                if (handledTypes.contains((Object)type) || !typedBlockArea.blockArea().isPositionInside(blockPos)) continue;
                if (type.getConfig().blockedSpawnReasons.contains(entitySpawnReason) && spawnBlocker.test(type)) break;
                handledTypes.add(type);
            }
        }
    }
}

