/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.compat.jei;

import com.beanbot.instrumentus.common.Instrumentus;
import com.beanbot.instrumentus.common.blocks.CopperSoulCampfireBlock;
import com.beanbot.instrumentus.common.blocks.InstrumentusBlocks;
import com.beanbot.instrumentus.common.blocks.KilnBlock;
import com.beanbot.instrumentus.common.recipe.InstrumentusRecipes;
import com.beanbot.instrumentus.compat.jei.CopperSoulCampfireCookingRecipeCategory;
import com.beanbot.instrumentus.compat.jei.FiringRecipeCategory;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class InstrumentusJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"instrumentus", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new CopperSoulCampfireCookingRecipeCategory(guiHelper), new FiringRecipeCategory(guiHelper)});
        Instrumentus.LOGGER.info("Registered JEI Categories");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        assert (Minecraft.getInstance().level != null);
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        List copperSoulCampfireRecipes = recipeManager.getAllRecipesFor(InstrumentusRecipes.COPPER_SOUL_CAMPFIRE_COOKING_TYPE.get()).stream().map(RecipeHolder::value).collect(Collectors.toList());
        List firingRecipes = recipeManager.getAllRecipesFor(InstrumentusRecipes.FIRING.get()).stream().map(RecipeHolder::value).collect(Collectors.toList());
        registration.addRecipes(CopperSoulCampfireCookingRecipeCategory.TYPE, copperSoulCampfireRecipes);
        registration.addRecipes(FiringRecipeCategory.TYPE, firingRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((CopperSoulCampfireBlock)((Object)InstrumentusBlocks.COPPER_SOUL_CAMPFIRE.get())).asItem()), new RecipeType[]{CopperSoulCampfireCookingRecipeCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((KilnBlock)((Object)InstrumentusBlocks.KILN.get())).asItem()), new RecipeType[]{FiringRecipeCategory.TYPE});
    }
}

