/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.compat.jei;

import com.beanbot.instrumentus.common.blocks.InstrumentusBlocks;
import com.beanbot.instrumentus.common.recipe.CopperSoulCampfireRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CopperSoulCampfireCookingRecipeCategory
implements IRecipeCategory<CopperSoulCampfireRecipe> {
    public static final RecipeType<CopperSoulCampfireRecipe> TYPE = RecipeType.create((String)"instrumentus", (String)"copper_soul_campfire_cooking", CopperSoulCampfireRecipe.class);
    private final IDrawable icon;
    private final Component localizedName;
    protected final IGuiHelper guiHelper;
    protected final IDrawableStatic staticFlame;
    protected final IDrawableAnimated animatedFlame;
    protected int regularCookTime;

    public CopperSoulCampfireCookingRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)InstrumentusBlocks.COPPER_SOUL_CAMPFIRE.get()));
        this.localizedName = Component.translatable((String)"instrumentus.coppersoulcampfirecookingrecipe.title");
        this.staticFlame = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"jei", (String)"textures/jei/gui/gui_vanilla.png"), 82, 114, 14, 14);
        this.animatedFlame = guiHelper.createAnimatedDrawable(this.staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.guiHelper = guiHelper;
        this.regularCookTime = 1200;
    }

    public RecipeType<CopperSoulCampfireRecipe> getRecipeType() {
        return TYPE;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public final int getWidth() {
        return 82;
    }

    public final int getHeight() {
        return 44;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    protected void addCookTime(IRecipeExtrasBuilder builder, CopperSoulCampfireRecipe recipe) {
        int cookTime = recipe.getCookingTime();
        if (cookTime <= 0) {
            cookTime = this.regularCookTime;
        }
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.translatable((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            ((ITextWidget)builder.addText((FormattedText)timeString, this.getWidth() - 20, 10).setPosition(0, 0, this.getWidth(), this.getHeight(), HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM)).setTextAlignment(HorizontalAlignment.RIGHT).setTextAlignment(VerticalAlignment.BOTTOM).setColor(-8355712);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CopperSoulCampfireRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).setStandardSlotBackground().addIngredients(recipe.input);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 9).setStandardSlotBackground().addItemStack(recipe.getResultItem());
    }

    public void createRecipeExtras(IRecipeExtrasBuilder acceptor, CopperSoulCampfireRecipe recipe, IFocusGroup focuses) {
        int cookTime = recipe.getCookingTime();
        if (cookTime <= 0) {
            cookTime = this.regularCookTime;
        }
        acceptor.addAnimatedRecipeArrow(cookTime).setPosition(26, 7);
        acceptor.addAnimatedRecipeFlame(300).setPosition(1, 20);
        this.addCookTime(acceptor, recipe);
    }

    public ResourceLocation getRegistryName(CopperSoulCampfireRecipe recipe) {
        return recipe.getId();
    }
}

