/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.compat.jade;

import com.beanbot.instrumentus.common.blocks.entities.CopperSoulCampfireBlockEntity;
import com.beanbot.instrumentus.compat.jade.InstrumentusIds;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import snownee.jade.api.Accessor;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;

public enum CopperFueledSoulCampfireProvider implements IServerExtensionProvider<ItemStack>,
IClientExtensionProvider<ItemStack, ItemView>
{
    INSTANCE;

    private static final MapCodec<Integer> COOKING_TIME_CODEC;

    public ResourceLocation getUid() {
        return InstrumentusIds.COPPER_FUELED_SOUL_CAMPFIRE;
    }

    public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<ItemStack>> groups) {
        return ClientViewGroup.map(groups, stack -> {
            CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            if (customData.isEmpty()) {
                return null;
            }
            Optional result = customData.read(COOKING_TIME_CODEC).result();
            if (result.isEmpty()) {
                return null;
            }
            String text = IThemeHelper.get().seconds(((Integer)result.get()).intValue(), accessor.tickRate()).getString();
            return new ItemView(stack).amountText(text);
        }, null);
    }

    @Nullable
    public List<ViewGroup<ItemStack>> getGroups(Accessor<?> accessor) {
        Object object = accessor.getTarget();
        if (object instanceof CopperSoulCampfireBlockEntity) {
            CopperSoulCampfireBlockEntity campfire = (CopperSoulCampfireBlockEntity)((Object)object);
            ArrayList list = Lists.newArrayList();
            for (int i = 0; i < campfire.cookingTime.length; ++i) {
                ItemStack stack = (ItemStack)campfire.getItems().get(i);
                if (stack.isEmpty()) continue;
                stack = stack.copy();
                CustomData customData = (CustomData)((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).update((DynamicOps)NbtOps.INSTANCE, COOKING_TIME_CODEC, (Object)(campfire.cookingTime[i] - campfire.cookingProgress[i])).getOrThrow();
                stack.set(DataComponents.CUSTOM_DATA, (Object)customData);
                list.add(stack);
            }
            return List.of(new ViewGroup((List)list));
        }
        return null;
    }

    static {
        COOKING_TIME_CODEC = Codec.INT.fieldOf("jade:cooking");
    }
}

