/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.compat.create.recipe;

import com.beanbot.instrumentus.client.particles.InstrumentusParticles;
import com.beanbot.instrumentus.common.blocks.InstrumentusBlocks;
import com.beanbot.instrumentus.common.recipe.InstrumentusRecipes;
import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.damageTypes.CreateDamageSources;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class InstrumentusFanProcessingTypes
extends AllFanProcessingTypes {
    public static final CopperSoulHauntingType COPPER_SOUL_HAUNTING = InstrumentusFanProcessingTypes.register("copper_soul_haunting", new CopperSoulHauntingType());
    private static final Map<String, FanProcessingType> LEGACY_NAME_MAP;

    private static <T extends FanProcessingType> T register(String name, T type) {
        return (T)((FanProcessingType)Registry.register((Registry)CreateBuiltInRegistries.FAN_PROCESSING_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"instrumentus", (String)name), type));
    }

    @Nullable
    public static FanProcessingType ofLegacyName(String name) {
        return LEGACY_NAME_MAP.get(name);
    }

    public static void init() {
    }

    public static FanProcessingType parseLegacy(String str) {
        FanProcessingType type = InstrumentusFanProcessingTypes.ofLegacyName(str);
        if (type != null) {
            return type;
        }
        return FanProcessingType.parse((String)str);
    }

    static {
        Object2ReferenceOpenHashMap map = new Object2ReferenceOpenHashMap();
        map.put((Object)"COPPER_SOUL_HAUNTING", (Object)COPPER_SOUL_HAUNTING);
        map.trim();
        LEGACY_NAME_MAP = map;
    }

    public static class CopperSoulHauntingType
    implements FanProcessingType {
        public boolean isValidAt(Level level, BlockPos pos) {
            BlockState blockState = level.getBlockState(pos);
            return blockState.is(InstrumentusBlocks.COPPER_SOUL_CAMPFIRE);
        }

        public int getPriority() {
            return 400;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            Optional recipe = level.getRecipeManager().getRecipeFor(InstrumentusRecipes.COPPER_SOUL_CAMPFIRE_COOKING_TYPE.get(), (RecipeInput)new SingleRecipeInput(stack), level);
            return recipe.isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            Optional recipe = level.getRecipeManager().getRecipeFor(InstrumentusRecipes.COPPER_SOUL_CAMPFIRE_COOKING_TYPE.get(), (RecipeInput)new SingleRecipeInput(stack), level);
            if (recipe.isPresent()) {
                return RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)((RecipeHolder)recipe.get()).value(), (boolean)false);
            }
            return null;
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            pos = pos.add(VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)level.random, (float)1.0f).multiply(1.0, (double)0.05f, 1.0).normalize().scale((double)0.15f));
            level.addParticle((ParticleOptions)((SimpleParticleType)InstrumentusParticles.COPPER_SOUL_FIRE_FLAME_PARTICLE.get()), pos.x, pos.y + (double)0.45f, pos.z, 0.0, 0.0, 0.0);
            if (level.random.nextInt(2) == 0) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0, 0.0);
            }
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)0, (int)1291104, (float)random.nextFloat()));
            particleAccess.setAlpha(1.0f);
            if (random.nextFloat() < 0.0078125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)((SimpleParticleType)InstrumentusParticles.COPPER_SOUL_FIRE_FLAME_PARTICLE.get()), 0.125f);
            }
            if (random.nextFloat() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.SMOKE, 0.125f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide) {
                return;
            }
            if (!entity.fireImmune()) {
                entity.igniteForSeconds(2.0f);
                entity.hurt(CreateDamageSources.fanFire((Level)level), 2.0f);
            }
        }
    }
}

