/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.recipe;

import com.beanbot.instrumentus.common.recipe.InstrumentusRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class CopperSoulCampfireRecipe
implements Recipe<SingleRecipeInput> {
    protected final ResourceLocation id;
    public final Ingredient input;
    public final ItemStack result;
    public int cookingTime;

    public CopperSoulCampfireRecipe(ResourceLocation id, Ingredient input, ItemStack result, int cookingTime) {
        this.id = id;
        this.input = input;
        this.result = result;
        this.cookingTime = cookingTime;
    }

    public boolean matches(SingleRecipeInput pInput, Level pLevel) {
        return this.input.test(pInput.item());
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ItemStack assemble(SingleRecipeInput pInput, HolderLookup.Provider holderProvider) {
        return this.result.copy();
    }

    public RecipeType<?> getType() {
        return InstrumentusRecipes.COPPER_SOUL_CAMPFIRE_COOKING_TYPE.get();
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)Blocks.SOUL_CAMPFIRE);
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider holderProvider) {
        return this.result;
    }

    public ItemStack getResultItem() {
        return this.getResultItem(null);
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonnulllist = NonNullList.create();
        nonnulllist.add((Object)this.input);
        return nonnulllist;
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack assemble(Container pContainer, RegistryAccess pRegistryAccess) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return InstrumentusRecipes.COPPER_SOUL_CAMPFIRE_COOKING_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<CopperSoulCampfireRecipe> {
        private static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"instrumentus", (String)"copper_soul_campfire_cooking");
        private static final MapCodec<CopperSoulCampfireRecipe> CODEC = RecordCodecBuilder.mapCodec(map -> map.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(idField -> idField.id), (App)Ingredient.CODEC.fieldOf("input").forGetter(inputField -> inputField.input), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(resultField -> resultField.result), (App)Codec.INT.fieldOf("cookingTime").forGetter(cookingTimeField -> cookingTimeField.cookingTime)).apply((Applicative)map, CopperSoulCampfireRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, CopperSoulCampfireRecipe> STREAM_CODEC = StreamCodec.of(this::toNetwork, this::fromNetwork);

        public MapCodec<CopperSoulCampfireRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CopperSoulCampfireRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        public CopperSoulCampfireRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            ResourceLocation resourceLocation = buf.readResourceLocation();
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            int cookingTime = buf.readVarInt();
            return new CopperSoulCampfireRecipe(resourceLocation, input, result, cookingTime);
        }

        public void toNetwork(RegistryFriendlyByteBuf buf, CopperSoulCampfireRecipe recipe) {
            buf.writeResourceLocation(recipe.id);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.input);
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.result);
            buf.writeVarInt(recipe.cookingTime);
        }
    }
}

