/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.items.interfaces;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public interface IEnergyItem {
    default public int getCharge(ItemStack stack) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null) {
            return -1;
        }
        return energyStorage.getEnergyStored();
    }

    default public float getChargeRatio(ItemStack stack) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null) {
            return 0.0f;
        }
        return (float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored();
    }

    default public boolean energyDamageEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null) {
            return false;
        }
        energyStorage.extractEnergy(this.getMaxTransferRate() - 24, false);
        return true;
    }

    default public int getEnergyBarWidth(ItemStack stack) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null) {
            return 13;
        }
        return Math.min(13 * energyStorage.getMaxEnergyStored() / energyStorage.getMaxEnergyStored(), 13);
    }

    default public boolean isEnergyBarVisible(ItemStack stack) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null) {
            return false;
        }
        return energyStorage.getEnergyStored() < energyStorage.getMaxEnergyStored();
    }

    default public int getEnergyBarColor(ItemStack stack) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null) {
            return -1;
        }
        return Mth.hsvToRgb((float)(Math.max(0.0f, (float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored()) / 3.0f), (float)1.0f, (float)1.0f);
    }

    default public boolean isEnergyBelowZero(ItemStack stack) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null) {
            return false;
        }
        return energyStorage.getEnergyStored() != energyStorage.getMaxEnergyStored();
    }

    default public void addTooltip(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        if (Capabilities.EnergyStorage.ITEM == null) {
            return;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null) {
            return;
        }
        MutableComponent energyText = Component.translatable((String)"instrumentus.lore.energy", (Object[])new Object[]{String.format("%,d", energyStorage.getEnergyStored()), String.format("%,d", energyStorage.getMaxEnergyStored())}).withStyle(ChatFormatting.DARK_GREEN);
        if (energyStorage.getEnergyStored() == 0) {
            energyText = Component.translatable((String)"instrumentus.lore.no_energy").withStyle(ChatFormatting.DARK_RED);
        }
        tooltip.add((Component)energyText);
    }

    default public int getMaxCapacity() {
        return 50000;
    }

    default public int getMaxTransferRate() {
        return 100;
    }
}

