/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.items;

import com.beanbot.instrumentus.common.blocks.CopperSoulFlameLight;
import com.beanbot.instrumentus.common.blocks.InstrumentusBlocks;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class SoulcopperPickaxeItem
extends DiggerItem {
    protected Tier material;

    public SoulcopperPickaxeItem(Tier tier, int attackDamageIn, float attackSpeedIn) {
        super(tier, BlockTags.MINEABLE_WITH_PICKAXE, SoulcopperPickaxeItem.generateItemProperties(tier, attackDamageIn, attackSpeedIn));
        this.material = tier;
    }

    private static Item.Properties generateItemProperties(Tier tier, float attackDamageIn, float attackSpeedIn) {
        if (tier == Tiers.NETHERITE) {
            return new Item.Properties().attributes(PickaxeItem.createAttributes((Tier)tier, (float)attackDamageIn, (float)attackSpeedIn)).stacksTo(1).fireResistant().durability(tier.getUses());
        }
        return new Item.Properties().attributes(PickaxeItem.createAttributes((Tier)tier, (float)attackDamageIn, (float)attackSpeedIn)).stacksTo(1).durability(tier.getUses());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        MutableComponent press = Component.translatable((String)"instrumentus.tooltip.press_shift").withStyle(ChatFormatting.GRAY);
        MutableComponent empty = Component.literal((String)"");
        MutableComponent pressed1 = Component.translatable((String)"instrumentus.tooltip.soulcopper_pickaxe_1").withStyle(ChatFormatting.GRAY);
        MutableComponent pressed2 = Component.translatable((String)"instrumentus.tooltip.soulcopper_pickaxe_2").withStyle(ChatFormatting.GRAY);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)press);
            tooltip.add((Component)empty);
            tooltip.add((Component)pressed1);
            tooltip.add((Component)pressed2);
        } else {
            tooltip.add((Component)press);
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Level worldIn = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (context.getClickedFace() == Direction.WEST && worldIn.isEmptyBlock(pos.west())) {
            worldIn.setBlockAndUpdate(new BlockPos(pos.getX() - 1, pos.getY(), pos.getZ()), ((CopperSoulFlameLight)((Object)InstrumentusBlocks.COPPER_SOUL_FLAME_LIGHT.get())).defaultBlockState());
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, context.getItemInHand().getEquipmentSlot());
        } else if (context.getClickedFace() == Direction.EAST && worldIn.isEmptyBlock(pos.east())) {
            worldIn.setBlockAndUpdate(new BlockPos(pos.getX() + 1, pos.getY(), pos.getZ()), ((CopperSoulFlameLight)((Object)InstrumentusBlocks.COPPER_SOUL_FLAME_LIGHT.get())).defaultBlockState());
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, context.getItemInHand().getEquipmentSlot());
        } else if (context.getClickedFace() == Direction.NORTH && worldIn.isEmptyBlock(pos.north())) {
            worldIn.setBlockAndUpdate(new BlockPos(pos.getX(), pos.getY(), pos.getZ() - 1), ((CopperSoulFlameLight)((Object)InstrumentusBlocks.COPPER_SOUL_FLAME_LIGHT.get())).defaultBlockState());
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, context.getItemInHand().getEquipmentSlot());
        } else if (context.getClickedFace() == Direction.SOUTH && worldIn.isEmptyBlock(pos.south())) {
            worldIn.setBlockAndUpdate(new BlockPos(pos.getX(), pos.getY(), pos.getZ() + 1), ((CopperSoulFlameLight)((Object)InstrumentusBlocks.COPPER_SOUL_FLAME_LIGHT.get())).defaultBlockState());
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, context.getItemInHand().getEquipmentSlot());
        } else if (context.getClickedFace() == Direction.DOWN && worldIn.isEmptyBlock(pos.below())) {
            worldIn.setBlockAndUpdate(new BlockPos(pos.getX(), pos.getY() - 1, pos.getZ()), ((CopperSoulFlameLight)((Object)InstrumentusBlocks.COPPER_SOUL_FLAME_LIGHT.get())).defaultBlockState());
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, context.getItemInHand().getEquipmentSlot());
        } else if (context.getClickedFace() == Direction.UP && worldIn.isEmptyBlock(pos.above())) {
            worldIn.setBlockAndUpdate(new BlockPos(pos.getX(), pos.getY() + 1, pos.getZ()), ((CopperSoulFlameLight)((Object)InstrumentusBlocks.COPPER_SOUL_FLAME_LIGHT.get())).defaultBlockState());
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, context.getItemInHand().getEquipmentSlot());
        } else {
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }
}

