/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.items;

import com.beanbot.instrumentus.common.data.generator.InstrumentusGeneratorBlockTags;
import com.beanbot.instrumentus.common.items.InstrumentusItemTiers;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class PaxelItem
extends DiggerItem {
    private static final ItemAbility PAXEL_DIG = ItemAbility.get((String)"paxel_dig");
    protected Tier material;
    public static final Set<ItemAbility> DEFAULT_PAXEL_ACTIONS = Set.of(ItemAbilities.AXE_DIG, ItemAbilities.AXE_STRIP, ItemAbilities.AXE_SCRAPE, ItemAbilities.AXE_WAX_OFF, ItemAbilities.SHOVEL_DIG, ItemAbilities.SHOVEL_FLATTEN, ItemAbilities.PICKAXE_DIG);

    public PaxelItem(Tier tier, float attackDamageIn, float attackSpeedIn) {
        super(tier, InstrumentusGeneratorBlockTags.MINEABLE_WITH_PAXEL, PaxelItem.generateItemProperties(tier, attackDamageIn, attackSpeedIn));
        this.material = tier;
    }

    private static Item.Properties generateItemProperties(Tier tier, float attackDamageIn, float attackSpeedIn) {
        if (tier == Tiers.NETHERITE || tier == InstrumentusItemTiers.ENERGIZED) {
            return new Item.Properties().attributes(AxeItem.createAttributes((Tier)tier, (float)attackDamageIn, (float)attackSpeedIn)).stacksTo(1).fireResistant();
        }
        return new Item.Properties().attributes(AxeItem.createAttributes((Tier)tier, (float)attackDamageIn, (float)attackSpeedIn)).stacksTo(1);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility toolAction) {
        return DEFAULT_PAXEL_ACTIONS.contains(toolAction) || toolAction == PAXEL_DIG;
    }

    public float getDestroySpeed(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        return super.getDestroySpeed(stack, state) == 1.0f ? 1.0f : this.material.getSpeed();
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = world.getBlockState(blockpos);
        BlockState resultToSet = this.useAsAxe(blockstate, context);
        Player player = context.getPlayer();
        if (resultToSet == null) {
            if (context.getClickedFace() == Direction.DOWN) {
                return InteractionResult.PASS;
            }
            BlockState foundResult = blockstate.getToolModifiedState(context, ItemAbilities.SHOVEL_FLATTEN, false);
            if (foundResult != null && world.isEmptyBlock(blockpos.above())) {
                world.playSound(player, blockpos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                resultToSet = foundResult;
            } else if (blockstate.getBlock() instanceof CampfireBlock && ((Boolean)blockstate.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                if (!world.isClientSide) {
                    world.levelEvent(null, 1009, blockpos, 0);
                }
                CampfireBlock.dowse((Entity)player, (LevelAccessor)world, (BlockPos)blockpos, (BlockState)blockstate);
                resultToSet = (BlockState)blockstate.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false));
            }
            if (resultToSet == null) {
                return InteractionResult.PASS;
            }
        }
        if (!world.isClientSide) {
            ItemStack stack = context.getItemInHand();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, blockpos, stack);
            }
            world.setBlock(blockpos, resultToSet, 11);
            if (player != null) {
                stack.hurtAndBreak(1, (LivingEntity)player, context.getItemInHand().getEquipmentSlot());
            }
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    @Nullable
    private BlockState useAsAxe(BlockState blockstate, UseOnContext context) {
        Level world = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        Player player = context.getPlayer();
        BlockState resultToSet = blockstate.getToolModifiedState(context, ItemAbilities.AXE_STRIP, false);
        if (resultToSet != null) {
            world.playSound(player, blockpos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            return resultToSet;
        }
        resultToSet = blockstate.getToolModifiedState(context, ItemAbilities.AXE_SCRAPE, false);
        if (resultToSet != null) {
            world.playSound(player, blockpos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return resultToSet;
        }
        resultToSet = blockstate.getToolModifiedState(context, ItemAbilities.AXE_WAX_OFF, false);
        if (resultToSet != null) {
            world.playSound(player, blockpos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
            return resultToSet;
        }
        return null;
    }
}

