/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.items;

import com.beanbot.instrumentus.common.items.InstrumentusItemTiers;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class KnifeItem
extends TieredItem {
    public KnifeItem(Tier tier, int attackDamageIn, float attackSpeedIn) {
        super(tier, KnifeItem.generateItemProperties(tier, attackDamageIn, attackSpeedIn));
    }

    private static Item.Properties generateItemProperties(Tier tier, float attackDamageIn, float attackSpeedIn) {
        if (tier == Tiers.NETHERITE || tier == InstrumentusItemTiers.ENERGIZED) {
            return new Item.Properties().attributes(DiggerItem.createAttributes((Tier)tier, (float)attackDamageIn, (float)attackSpeedIn)).stacksTo(1).fireResistant();
        }
        return new Item.Properties().attributes(DiggerItem.createAttributes((Tier)tier, (float)attackDamageIn, (float)attackSpeedIn)).stacksTo(1);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        MutableComponent press = Component.translatable((String)"instrumentus.tooltip.press_shift").withStyle(ChatFormatting.GRAY);
        MutableComponent empty = Component.literal((String)"");
        MutableComponent pressed1 = Component.translatable((String)"instrumentus.tooltip.knife_1").withStyle(ChatFormatting.GRAY);
        MutableComponent pressed2 = Component.translatable((String)"instrumentus.tooltip.knife_2").withStyle(ChatFormatting.GRAY);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)press);
            tooltip.add((Component)empty);
            tooltip.add((Component)pressed1);
            tooltip.add((Component)pressed2);
        } else {
            tooltip.add((Component)press);
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null && this.calculateHitResult(player).getType() == HitResult.Type.BLOCK) {
            player.startUsingItem(context.getHand());
        }
        return InteractionResult.CONSUME;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BRUSH;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 60;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (remainingUseDuration >= 0 && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            HitResult hitResult = this.calculateHitResult(player);
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                if (hitResult.getType() == HitResult.Type.BLOCK) {
                    boolean flag;
                    int i = this.getUseDuration(stack, livingEntity) - remainingUseDuration + 1;
                    boolean bl = flag = i % 10 == 5;
                    if (flag) {
                        BlockPos blockPos = blockHitResult.getBlockPos();
                        BlockState attachedState = level.getBlockState(blockPos.relative(blockHitResult.getDirection()));
                        if (attachedState.is(Blocks.GLOW_LICHEN)) {
                            level.playSound(player, blockPos, SoundEvents.SLIME_ATTACK, SoundSource.BLOCKS, 0.3f, level.random.nextFloat() * 0.1f + 0.9f);
                            if (player.getUseItemRemainingTicks() <= 6) {
                                if (!level.isClientSide()) {
                                    double d0 = EntityType.ITEM.getWidth();
                                    double d1 = 1.0 - d0;
                                    double d2 = d0 / 2.0;
                                    double d3 = (double)blockPos.getX() + 0.5 * d1 + d2;
                                    double d4 = (double)blockPos.getY() + 0.5 + (double)(EntityType.ITEM.getHeight() / 2.0f);
                                    double d5 = (double)blockPos.getZ() + 0.5 * d1 + d2;
                                    ItemStack droppedStack = new ItemStack((ItemLike)Items.SLIME_BALL);
                                    droppedStack.setCount(1);
                                    ItemEntity itemEntity = new ItemEntity(level, d3, d4, d5, droppedStack.split(level.random.nextInt(21) + 10));
                                    ItemSpawnDelta itemSpawnDelta = ItemSpawnDelta.fromDirection(blockHitResult.getDirection());
                                    itemEntity.setDeltaMovement(itemSpawnDelta.x(), itemSpawnDelta.y(), itemSpawnDelta.z());
                                    level.addFreshEntity((Entity)itemEntity);
                                    EquipmentSlot equipmentSlot = stack.equals(player.getItemBySlot(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
                                    stack.hurtAndBreak(1, livingEntity, equipmentSlot);
                                    if (level.random.nextInt(0, 100) > 60) {
                                        level.destroyBlock(blockPos.relative(blockHitResult.getDirection()), false);
                                    }
                                }
                                level.playSound(player, blockPos, SoundEvents.BUCKET_FILL_LAVA, SoundSource.BLOCKS, 3.0f, 2.0f);
                            }
                        } else {
                            level.playSound(player, blockPos, SoundEvents.WOLF_ARMOR_CRACK, SoundSource.BLOCKS, 0.05f, 1.0f);
                        }
                    }
                    return;
                }
            }
            livingEntity.releaseUsingItem();
        } else {
            livingEntity.releaseUsingItem();
        }
    }

    private HitResult calculateHitResult(Player player) {
        return ProjectileUtil.getHitResultOnViewVector((Entity)player, p -> !p.isSpectator() && p.isPickable(), (double)player.blockInteractionRange());
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState block) {
        return block.is(Blocks.TALL_GRASS) || block.is(Blocks.SHORT_GRASS);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        return true;
    }

    public boolean mineBlock(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if ((double)state.getDestroySpeed((BlockGetter)worldIn, pos) != 0.0 || state.is(Blocks.SHORT_GRASS)) {
            stack.hurtAndBreak(2, entityLiving, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    record ItemSpawnDelta(double x, double y, double z) {
        public static ItemSpawnDelta fromDirection(Direction direction) {
            double d0 = 0.2;
            return switch (direction) {
                default -> throw new MatchException(null, null);
                case Direction.UP -> new ItemSpawnDelta(0.0, d0, 0.0);
                case Direction.DOWN -> new ItemSpawnDelta(0.0, -d0, 0.0);
                case Direction.NORTH -> new ItemSpawnDelta(0.0, 0.0, -d0);
                case Direction.SOUTH -> new ItemSpawnDelta(0.0, 0.0, d0);
                case Direction.WEST -> new ItemSpawnDelta(-d0, 0.0, 0.0);
                case Direction.EAST -> new ItemSpawnDelta(d0, 0.0, 0.0);
            };
        }
    }
}

