/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.items;

import com.beanbot.instrumentus.common.items.InstrumentusItemTiers;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;

public class HammerItem
extends DiggerItem {
    protected Tier tier;

    public HammerItem(Tier tier, float attackDamageIn, float attackSpeedIn) {
        super(tier, BlockTags.MINEABLE_WITH_PICKAXE, HammerItem.generateItemProperties(tier, attackDamageIn, attackSpeedIn));
        this.tier = tier;
    }

    private static Item.Properties generateItemProperties(Tier tier, float attackDamageIn, float attackSpeedIn) {
        if (tier == Tiers.NETHERITE || tier == InstrumentusItemTiers.ENERGIZED) {
            return new Item.Properties().attributes(HammerItem.createAttributes((Tier)tier, (float)attackDamageIn, (float)attackSpeedIn)).stacksTo(1).fireResistant();
        }
        return new Item.Properties().attributes(HammerItem.createAttributes((Tier)tier, (float)attackDamageIn, (float)attackSpeedIn)).stacksTo(1);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        MutableComponent press = Component.translatable((String)"instrumentus.tooltip.press_shift").withStyle(ChatFormatting.GRAY);
        MutableComponent empty = Component.literal((String)"");
        MutableComponent pressed1 = Component.translatable((String)"instrumentus.tooltip.hammer_1").withStyle(ChatFormatting.GRAY);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)press);
            tooltip.add((Component)empty);
            tooltip.add((Component)pressed1);
        } else {
            tooltip.add((Component)press);
        }
    }

    public boolean canPerformAction(@NotNull ItemStack stack, @NotNull ItemAbility ability) {
        return ItemAbilities.DEFAULT_PICKAXE_ACTIONS.contains(ability);
    }

    public boolean mineBlock(@NotNull ItemStack stack, @NotNull Level level, BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity entity) {
        int r;
        if (state.getBlock() == null || level.getBlockState(pos).getBlock() == Blocks.AIR) {
            return false;
        }
        boolean isPickaxeable = state.is(BlockTags.MINEABLE_WITH_PICKAXE);
        int n = r = isPickaxeable ? 0 : 2;
        if (this.tier == Tiers.WOOD || this.tier == Tiers.STONE || this.tier == Tiers.IRON || this.tier == InstrumentusItemTiers.COPPER || this.tier == Tiers.GOLD || this.tier == Tiers.DIAMOND || this.tier == Tiers.NETHERITE || this.tier == InstrumentusItemTiers.ENERGIZED) {
            r = 1;
        }
        stack.hurtAndBreak(1, entity, EquipmentSlot.MAINHAND);
        int numberTrimmed = 0;
        if (isPickaxeable && !entity.isCrouching()) {
            numberTrimmed += this.trim(stack, entity, level, pos, r, TrimType.TRIM_ROCK);
        }
        return numberTrimmed > 0;
    }

    public int trim(ItemStack stack, LivingEntity entity, Level level, BlockPos blockPos, int r, TrimType trimType) {
        int numberTrimmed;
        block7: {
            Direction blockFaceMined;
            block8: {
                block6: {
                    numberTrimmed = 0;
                    Player player = (Player)entity;
                    BlockHitResult blockHitResult = new BlockHitResult(new Vec3(player.getX(), player.getY(), player.getZ()), HammerItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE).getDirection(), blockPos, false);
                    blockFaceMined = blockHitResult.getDirection();
                    if (blockFaceMined != Direction.EAST && blockFaceMined != Direction.WEST) break block6;
                    for (int dz = -r; dz <= r; ++dz) {
                        for (int dy = -r; dy <= r; ++dy) {
                            if (dy == 0 && dz == 0 || !trimType.trimAtPos(level, blockPos.offset(0, dy, dz), entity, stack)) continue;
                            ++numberTrimmed;
                            stack.hurtAndBreak(1, entity, EquipmentSlot.MAINHAND);
                        }
                    }
                    break block7;
                }
                if (blockFaceMined != Direction.NORTH && blockFaceMined != Direction.SOUTH) break block8;
                for (int dx = -r; dx <= r; ++dx) {
                    for (int dy = -r; dy <= r; ++dy) {
                        if (dy == 0 && dx == 0 || !trimType.trimAtPos(level, blockPos.offset(dx, dy, 0), entity, stack)) continue;
                        ++numberTrimmed;
                        stack.hurtAndBreak(1, entity, EquipmentSlot.MAINHAND);
                    }
                }
                break block7;
            }
            if (blockFaceMined != Direction.UP && blockFaceMined != Direction.DOWN) break block7;
            for (int dx = -r; dx <= r; ++dx) {
                for (int dz = -r; dz <= r; ++dz) {
                    if (dz == 0 && dx == 0 || !trimType.trimAtPos(level, blockPos.offset(dx, 0, dz), entity, stack)) continue;
                    ++numberTrimmed;
                    stack.hurtAndBreak(1, entity, EquipmentSlot.MAINHAND);
                }
            }
        }
        return numberTrimmed;
    }

    public static enum TrimType {
        TRIM_ROCK;


        public boolean trimAtPos(Level level, BlockPos pos, LivingEntity entity, ItemStack item) {
            boolean bl;
            BlockState state = level.getBlockState(pos);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(level, pos, state, (Player)entity);
            NeoForge.EVENT_BUS.post((Event)event);
            switch (this.ordinal()) {
                default: 
            }
            if (state.is(BlockTags.MINEABLE_WITH_PICKAXE) && state.canHarvestBlock((BlockGetter)level, pos, (Player)entity)) {
                state.getBlock().playerDestroy(level, (Player)entity, pos, state, blockEntity, item);
                level.removeBlock(pos, false);
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }
    }
}

