/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.items;

import com.beanbot.instrumentus.common.items.InstrumentusItemTiers;
import com.beanbot.instrumentus.common.items.SickleItem;
import com.beanbot.instrumentus.common.items.interfaces.IEnergyItem;
import com.beanbot.instrumentus.common.items.interfaces.IItemLightningChargeable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.PitcherCropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergySickleItem
extends SickleItem
implements IItemLightningChargeable,
IEnergyItem {
    protected Tier tier;

    public EnergySickleItem(Tier tier) {
        super(tier);
        this.tier = tier;
    }

    private static boolean isGrownCrop(BlockState state) {
        if (state.is(BlockTags.CROPS)) {
            if (state.is(Blocks.PITCHER_CROP)) {
                int maxAge = 4;
                return (Integer)state.getValue((Property)PitcherCropBlock.AGE) == maxAge;
            }
            if (state.is(Blocks.PUMPKIN_STEM) || state.is(Blocks.MELON_STEM)) {
                int maxAge = 7;
                return (Integer)state.getValue((Property)StemBlock.AGE) == maxAge;
            }
            CropBlock cropBlock = (CropBlock)state.getBlock();
            int maxAge = cropBlock.getMaxAge();
            if (state.is(Blocks.BEETROOTS)) {
                return (Integer)state.getValue((Property)BeetrootBlock.AGE) == maxAge;
            }
            return (Integer)state.getValue((Property)CropBlock.AGE) == maxAge;
        }
        return false;
    }

    @Override
    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        IEnergyStorage energyStorage;
        int height;
        if (state.getBlock() == null || world.getBlockState(pos).getBlock() == Blocks.AIR) {
            return false;
        }
        boolean isLeaves = state.is(BlockTags.LEAVES);
        boolean isCrops = state.is(BlockTags.CROPS) && EnergySickleItem.isGrownCrop(state);
        int radius = isLeaves ? 0 : 2;
        int n = height = isLeaves ? 0 : 2;
        if (this.tier == Tiers.WOOD || this.tier == Tiers.STONE) {
            radius = 1;
            height = 1;
        }
        if (this.tier == Tiers.IRON || this.tier == Tiers.GOLD || this.tier == Tiers.DIAMOND) {
            radius = 2;
            height = 2;
        }
        if (this.tier == Tiers.NETHERITE || this.tier == InstrumentusItemTiers.ENERGIZED) {
            radius = 3;
            height = 3;
        }
        if ((energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) != null && state.getDestroySpeed((BlockGetter)world, pos) != 0.0f) {
            energyStorage.extractEnergy(this.getMaxTransferRate() - 24, false);
        }
        int numberTrimmed = 0;
        if (isLeaves && !entity.isCrouching()) {
            numberTrimmed += this.trim(stack, entity, world, pos, height, radius, SickleItem.TrimType.TRIM_LEAVES, false, 40);
        } else if (isCrops && !entity.isCrouching()) {
            numberTrimmed += this.trim(stack, entity, world, pos, 0, 1, SickleItem.TrimType.TRIM_CROPS, false, 40);
        } else {
            numberTrimmed += this.trim(stack, entity, world, pos, height, radius, SickleItem.TrimType.TRIM_GRASS_AND_FLOWERS, true, 70);
            if (world.random.nextInt(3) == 0) {
                numberTrimmed += this.trim(stack, entity, world, pos, height, radius - 1, SickleItem.TrimType.TRIM_GRASS_AND_FLOWERS, false, 0);
            }
        }
        return numberTrimmed > 0;
    }

    @Override
    public int trim(ItemStack stack, LivingEntity entity, Level world, BlockPos pos, int height, int radius, SickleItem.TrimType trimType, boolean cutCorners, int damagePercentChance) {
        int numberTrimmed = 0;
        boolean fortune = false;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (dx == 0 && dy == 0 && dz == 0 || cutCorners && Math.abs(dz) >= 2 * radius || !trimType.trimAtPos(world, pos.subtract(new Vec3i(dx, dy, dz).multiply(-1)), entity, stack)) continue;
                    ++numberTrimmed;
                    IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                    if (energyStorage == null) continue;
                    energyStorage.extractEnergy(this.getMaxTransferRate() - 24, false);
                }
            }
        }
        return numberTrimmed;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return this.energyDamageEnemy(stack, target, attacker);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null) {
            return 0.0f;
        }
        if (energyStorage.getEnergyStored() <= 0) {
            return 0.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        this.addTooltip(stack, context, tooltip, flagIn);
    }

    public int getBarWidth(ItemStack stack) {
        return this.getEnergyBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return this.getEnergyBarColor(stack);
    }

    public boolean isDamaged(ItemStack stack) {
        return this.isEnergyBelowZero(stack);
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.isEnergyBarVisible(stack);
    }
}

