/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.items;

import com.beanbot.instrumentus.common.items.InstrumentusShearsItem;
import com.beanbot.instrumentus.common.items.interfaces.IEnergyItem;
import com.beanbot.instrumentus.common.items.interfaces.IItemLightningChargeable;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyShearsItem
extends InstrumentusShearsItem
implements IItemLightningChargeable,
IEnergyItem {
    public EnergyShearsItem(Tier material) {
        super(material);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity entity, InteractionHand hand) {
        IEnergyStorage energyStorage;
        if (entity.level().isClientSide) {
            return InteractionResult.PASS;
        }
        if (entity instanceof IShearable && (energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) != null) {
            if (energyStorage.getEnergyStored() <= 0) {
                return InteractionResult.PASS;
            }
            IShearable target = (IShearable)entity;
            BlockPos pos = BlockPos.containing((Position)entity.position());
            if (target.isShearable(playerIn, stack, entity.level(), pos)) {
                target.onSheared(playerIn, stack, entity.level(), pos).forEach(drop -> target.spawnShearedDrop(entity.level(), pos, drop));
                entity.gameEvent((Holder)GameEvent.SHEAR, (Entity)playerIn);
                if (energyStorage != null) {
                    energyStorage.extractEnergy(this.getMaxTransferRate() - 24, false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean mineBlock(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        IEnergyStorage energyStorage = (IEnergyStorage)pStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (!pLevel.isClientSide && !pState.is(BlockTags.FIRE) && energyStorage != null) {
            energyStorage.extractEnergy(this.getMaxTransferRate() - 24, false);
        }
        return pState.is(BlockTags.LEAVES) || pState.is(Blocks.COBWEB) || pState.is(Blocks.SHORT_GRASS) || pState.is(Blocks.FERN) || pState.is(Blocks.DEAD_BUSH) || pState.is(Blocks.HANGING_ROOTS) || pState.is(Blocks.VINE) || pState.is(Blocks.TRIPWIRE) || pState.is(BlockTags.WOOL);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return this.energyDamageEnemy(stack, target, attacker);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null) {
            return 0.0f;
        }
        if (energyStorage.getEnergyStored() <= 0) {
            return 0.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        this.addTooltip(stack, context, tooltip, flagIn);
        MutableComponent press = Component.translatable((String)"instrumentus.tooltip.press_shift").withStyle(ChatFormatting.GRAY);
        MutableComponent empty = Component.literal((String)"");
        MutableComponent pressed1 = Component.translatable((String)"instrumentus.tooltip.shears_1").withStyle(ChatFormatting.GRAY);
        MutableComponent pressed2 = Component.translatable((String)"instrumentus.tooltip.shears_2").withStyle(ChatFormatting.GRAY);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)press);
            tooltip.add((Component)empty);
            tooltip.add((Component)pressed1);
            tooltip.add((Component)pressed2);
        } else {
            tooltip.add((Component)press);
        }
    }

    public int getBarWidth(ItemStack stack) {
        return this.getEnergyBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return this.getEnergyBarColor(stack);
    }

    public boolean isDamaged(ItemStack stack) {
        return this.isEnergyBelowZero(stack);
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.isEnergyBarVisible(stack);
    }
}

