/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.items;

import com.beanbot.instrumentus.common.items.PaxelItem;
import com.beanbot.instrumentus.common.items.interfaces.IEnergyItem;
import com.beanbot.instrumentus.common.items.interfaces.IItemLightningChargeable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class EnergyPaxelItem
extends PaxelItem
implements IItemLightningChargeable,
IEnergyItem {
    public EnergyPaxelItem(Tier material, float attackDamageIn, float attackSpeedIn) {
        super(material, attackDamageIn, attackSpeedIn);
    }

    @Override
    public int getMaxCapacity() {
        return 80000;
    }

    @Override
    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = world.getBlockState(blockpos);
        BlockState resultToSet = this.useAsAxe(blockstate, context);
        Player player = context.getPlayer();
        if (resultToSet == null) {
            if (context.getClickedFace() == Direction.DOWN) {
                return InteractionResult.PASS;
            }
            BlockState foundResult = blockstate.getToolModifiedState(context, ItemAbilities.SHOVEL_FLATTEN, false);
            if (foundResult != null && world.isEmptyBlock(blockpos.above())) {
                world.playSound(player, blockpos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                resultToSet = foundResult;
            } else if (blockstate.getBlock() instanceof CampfireBlock && ((Boolean)blockstate.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                if (!world.isClientSide) {
                    world.levelEvent(null, 1009, blockpos, 0);
                }
                CampfireBlock.dowse((Entity)player, (LevelAccessor)world, (BlockPos)blockpos, (BlockState)blockstate);
                resultToSet = (BlockState)blockstate.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false));
            }
            if (resultToSet == null) {
                return InteractionResult.PASS;
            }
        }
        if (!world.isClientSide) {
            IEnergyStorage energyStorage;
            ItemStack stack = context.getItemInHand();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, blockpos, stack);
            }
            if (player != null && (energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) != null) {
                if (energyStorage.getEnergyStored() == 0) {
                    return InteractionResult.FAIL;
                }
                world.setBlock(blockpos, resultToSet, 11);
                world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)resultToSet));
                energyStorage.extractEnergy(this.getMaxTransferRate() - 24, false);
            }
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    @Nullable
    private BlockState useAsAxe(BlockState blockstate, UseOnContext context) {
        Level world = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        Player player = context.getPlayer();
        BlockState resultToSet = blockstate.getToolModifiedState(context, ItemAbilities.AXE_STRIP, false);
        if (resultToSet != null) {
            world.playSound(player, blockpos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            return resultToSet;
        }
        resultToSet = blockstate.getToolModifiedState(context, ItemAbilities.AXE_SCRAPE, false);
        if (resultToSet != null) {
            world.playSound(player, blockpos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return resultToSet;
        }
        resultToSet = blockstate.getToolModifiedState(context, ItemAbilities.AXE_WAX_OFF, false);
        if (resultToSet != null) {
            world.playSound(player, blockpos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
            return resultToSet;
        }
        return null;
    }

    public boolean mineBlock(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        IEnergyStorage energyStorage;
        Player player;
        if (!(stack.getItem() instanceof IEnergyItem)) {
            return false;
        }
        if (entityLiving instanceof Player && !(player = (Player)entityLiving).isCreative() && (energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) != null && state.getDestroySpeed((BlockGetter)worldIn, pos) != 0.0f) {
            energyStorage.extractEnergy(this.getMaxTransferRate() - 24, false);
        }
        return true;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return this.energyDamageEnemy(stack, target, attacker);
    }

    @Override
    public float getDestroySpeed(@NotNull ItemStack stack, @NotNull BlockState state) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null) {
            return 0.0f;
        }
        if (energyStorage.getEnergyStored() <= 0) {
            return 0.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        this.addTooltip(stack, context, tooltip, flagIn);
    }

    public int getBarWidth(ItemStack stack) {
        return this.getEnergyBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return this.getEnergyBarColor(stack);
    }

    public boolean isDamaged(ItemStack stack) {
        return this.isEnergyBelowZero(stack);
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.isEnergyBarVisible(stack);
    }
}

