/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.items;

import com.beanbot.instrumentus.common.items.interfaces.IEnergyItem;
import com.beanbot.instrumentus.common.items.interfaces.IItemLightningChargeable;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyHoeItem
extends DiggerItem
implements IItemLightningChargeable,
IEnergyItem {
    public EnergyHoeItem(Tier tier, float attackDamageIn, float attackSpeedIn) {
        super(tier, BlockTags.MINEABLE_WITH_HOE, new Item.Properties().attributes(AxeItem.createAttributes((Tier)tier, (float)attackDamageIn, (float)attackSpeedIn)).durability(0).stacksTo(1).fireResistant());
    }

    public InteractionResult useOn(UseOnContext context) {
        Pair pair;
        BlockPos blockpos;
        Level level = context.getLevel();
        BlockState toolModifiedState = level.getBlockState(blockpos = context.getClickedPos()).getToolModifiedState(context, ItemAbilities.HOE_TILL, false);
        Pair pair2 = pair = toolModifiedState == null ? null : Pair.of(ctx -> true, EnergyHoeItem.changeIntoState(toolModifiedState));
        if (pair == null) {
            return InteractionResult.PASS;
        }
        Predicate predicate = (Predicate)pair.getFirst();
        Consumer consumer = (Consumer)pair.getSecond();
        if (predicate.test(context)) {
            Player player = context.getPlayer();
            level.playSound(player, blockpos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.isClientSide && player != null) {
                IEnergyStorage energyStorage = (IEnergyStorage)context.getItemInHand().getCapability(Capabilities.EnergyStorage.ITEM);
                if (energyStorage == null) {
                    return InteractionResult.FAIL;
                }
                if (energyStorage.getEnergyStored() == 0) {
                    return InteractionResult.FAIL;
                }
                consumer.accept(context);
                energyStorage.extractEnergy(this.getMaxTransferRate() - 24, false);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static Consumer<UseOnContext> changeIntoState(BlockState blockState) {
        return context -> {
            context.getLevel().setBlock(context.getClickedPos(), blockState, 11);
            context.getLevel().gameEvent((Holder)GameEvent.BLOCK_CHANGE, context.getClickedPos(), GameEvent.Context.of((Entity)context.getPlayer(), (BlockState)blockState));
        };
    }

    public static Consumer<UseOnContext> changeIntoStateAndDropItem(BlockState blockState, ItemLike itemToDrop) {
        return context -> {
            context.getLevel().setBlock(context.getClickedPos(), blockState, 11);
            context.getLevel().gameEvent((Holder)GameEvent.BLOCK_CHANGE, context.getClickedPos(), GameEvent.Context.of((Entity)context.getPlayer(), (BlockState)blockState));
            Block.popResourceFromFace((Level)context.getLevel(), (BlockPos)context.getClickedPos(), (Direction)context.getClickedFace(), (ItemStack)new ItemStack(itemToDrop));
        };
    }

    public static boolean onlyIfAirAbove(UseOnContext context) {
        return context.getClickedFace() != Direction.DOWN && context.getLevel().getBlockState(context.getClickedPos().above()).isAir();
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_HOE_ACTIONS.contains(itemAbility);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return this.energyDamageEnemy(stack, target, attacker);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null) {
            return 0.0f;
        }
        if (energyStorage.getEnergyStored() <= 0) {
            return 0.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean mineBlock(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        Player player;
        if (!(stack.getItem() instanceof IEnergyItem)) {
            return false;
        }
        if (entityLiving instanceof Player && !(player = (Player)entityLiving).isCreative()) {
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null) {
                return false;
            }
            if (state.getDestroySpeed((BlockGetter)worldIn, pos) != 0.0f) {
                energyStorage.extractEnergy(this.getMaxTransferRate() - 24, false);
            }
        }
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        this.addTooltip(stack, context, tooltip, flagIn);
    }

    public int getBarWidth(ItemStack stack) {
        return this.getEnergyBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return this.getEnergyBarColor(stack);
    }

    public boolean isDamaged(ItemStack stack) {
        return this.isEnergyBelowZero(stack);
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.isEnergyBarVisible(stack);
    }
}

