/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.items;

import com.beanbot.instrumentus.common.items.HammerItem;
import com.beanbot.instrumentus.common.items.InstrumentusItemTiers;
import com.beanbot.instrumentus.common.items.interfaces.IEnergyItem;
import com.beanbot.instrumentus.common.items.interfaces.IItemLightningChargeable;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;

public class EnergyHammerItem
extends HammerItem
implements IItemLightningChargeable,
IEnergyItem {
    protected Tier tier;

    public EnergyHammerItem(Tier tier, float attackDamageIn, float attackSpeedIn) {
        super(tier, attackSpeedIn, attackDamageIn);
        this.tier = tier;
    }

    @Override
    public int getMaxCapacity() {
        return 80000;
    }

    @Override
    public boolean mineBlock(@NotNull ItemStack stack, @NotNull Level level, BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity entity) {
        int r;
        if (state.getBlock() == null || level.getBlockState(pos).getBlock() == Blocks.AIR) {
            return false;
        }
        boolean isPickaxeable = state.is(BlockTags.MINEABLE_WITH_PICKAXE);
        int n = r = isPickaxeable ? 0 : 2;
        if (this.tier == Tiers.WOOD || this.tier == Tiers.STONE || this.tier == Tiers.IRON || this.tier == Tiers.GOLD || this.tier == Tiers.DIAMOND || this.tier == Tiers.NETHERITE || this.tier == InstrumentusItemTiers.ENERGIZED) {
            r = 1;
        }
        stack.hurtAndBreak(1, entity, EquipmentSlot.MAINHAND);
        int numberTrimmed = 0;
        if (isPickaxeable && !entity.isCrouching()) {
            numberTrimmed += this.trim(stack, entity, level, pos, r, TrimType.TRIM_ROCK);
        }
        return numberTrimmed > 0;
    }

    public int trim(ItemStack stack, LivingEntity entity, Level level, BlockPos blockPos, int r, TrimType trimType) {
        int numberTrimmed;
        block7: {
            Direction blockFaceMined;
            block8: {
                block6: {
                    numberTrimmed = 0;
                    Player player = (Player)entity;
                    BlockHitResult blockHitResult = new BlockHitResult(new Vec3(player.getX(), player.getY(), player.getZ()), EnergyHammerItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE).getDirection(), blockPos, false);
                    blockFaceMined = blockHitResult.getDirection();
                    if (blockFaceMined != Direction.EAST && blockFaceMined != Direction.WEST) break block6;
                    for (int dz = -r; dz <= r; ++dz) {
                        for (int dy = -r; dy <= r; ++dy) {
                            if (dy == 0 && dz == 0 || !trimType.trimAtPos(level, blockPos.offset(0, dy, dz), entity, stack)) continue;
                            ++numberTrimmed;
                            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                            if (energyStorage == null || level.getBlockState(blockPos).getDestroySpeed((BlockGetter)level, blockPos) == 0.0f) continue;
                            energyStorage.extractEnergy(this.getMaxTransferRate() - 24, false);
                        }
                    }
                    break block7;
                }
                if (blockFaceMined != Direction.NORTH && blockFaceMined != Direction.SOUTH) break block8;
                for (int dx = -r; dx <= r; ++dx) {
                    for (int dy = -r; dy <= r; ++dy) {
                        if (dy == 0 && dx == 0 || !trimType.trimAtPos(level, blockPos.offset(dx, dy, 0), entity, stack)) continue;
                        ++numberTrimmed;
                        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                        if (energyStorage == null || level.getBlockState(blockPos).getDestroySpeed((BlockGetter)level, blockPos) == 0.0f) continue;
                        energyStorage.extractEnergy(this.getMaxTransferRate() - 24, false);
                    }
                }
                break block7;
            }
            if (blockFaceMined != Direction.UP && blockFaceMined != Direction.DOWN) break block7;
            for (int dx = -r; dx <= r; ++dx) {
                for (int dz = -r; dz <= r; ++dz) {
                    if (dz == 0 && dx == 0 || !trimType.trimAtPos(level, blockPos.offset(dx, 0, dz), entity, stack)) continue;
                    ++numberTrimmed;
                    IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                    if (energyStorage == null || level.getBlockState(blockPos).getDestroySpeed((BlockGetter)level, blockPos) == 0.0f) continue;
                    energyStorage.extractEnergy(this.getMaxTransferRate() - 24, false);
                }
            }
        }
        return numberTrimmed;
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        return this.energyDamageEnemy(stack, target, attacker);
    }

    public float getDestroySpeed(ItemStack stack, @NotNull BlockState state) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null) {
            return 0.0f;
        }
        if (energyStorage.getEnergyStored() <= 0) {
            return 0.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        this.addTooltip(stack, context, tooltip, flagIn);
        MutableComponent press = Component.translatable((String)"instrumentus.tooltip.press_shift").withStyle(ChatFormatting.GRAY);
        MutableComponent empty = Component.literal((String)"");
        MutableComponent pressed1 = Component.translatable((String)"instrumentus.tooltip.hammer_1").withStyle(ChatFormatting.GRAY);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)press);
            tooltip.add((Component)empty);
            tooltip.add((Component)pressed1);
        } else {
            tooltip.add((Component)press);
        }
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return this.getEnergyBarWidth(stack);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return this.getEnergyBarColor(stack);
    }

    public boolean isDamaged(@NotNull ItemStack stack) {
        return this.isEnergyBelowZero(stack);
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return this.isEnergyBarVisible(stack);
    }

    public static enum TrimType {
        TRIM_ROCK;


        public boolean trimAtPos(Level world, BlockPos pos, LivingEntity entity, ItemStack item) {
            boolean bl;
            BlockState state = world.getBlockState(pos);
            BlockEntity blockEntity = world.getBlockEntity(pos);
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, (Player)entity);
            NeoForge.EVENT_BUS.post((Event)event);
            switch (this.ordinal()) {
                default: 
            }
            if (state.is(BlockTags.MINEABLE_WITH_PICKAXE) && state.canHarvestBlock((BlockGetter)world, pos, (Player)entity)) {
                state.getBlock().playerDestroy(world, (Player)entity, pos, state, blockEntity, item);
                world.removeBlock(pos, false);
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }
    }
}

