/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.items;

import com.beanbot.instrumentus.common.items.interfaces.IEnergyItem;
import com.beanbot.instrumentus.common.items.interfaces.IItemLightningChargeable;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyBrushItem
extends BrushItem
implements IItemLightningChargeable,
IEnergyItem {
    public EnergyBrushItem() {
        super(new Item.Properties().durability(0).stacksTo(1).fireResistant());
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Player player = pContext.getPlayer();
        IEnergyStorage energyStorage = (IEnergyStorage)pContext.getItemInHand().getCapability(Capabilities.EnergyStorage.ITEM);
        if (player != null && this.calculateHitResult(player).getType() == HitResult.Type.BLOCK && energyStorage != null && energyStorage.getEnergyStored() > 0) {
            player.startUsingItem(pContext.getHand());
        }
        return InteractionResult.CONSUME;
    }

    public void onUseTick(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        if (pRemainingUseDuration >= 0 && pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            HitResult hitresult = this.calculateHitResult(player);
            if (hitresult instanceof BlockHitResult) {
                BlockHitResult blockhitresult = (BlockHitResult)hitresult;
                if (hitresult.getType() == HitResult.Type.BLOCK) {
                    boolean flag;
                    int i = this.getUseDuration(pStack, pLivingEntity) - pRemainingUseDuration + 1;
                    boolean bl = flag = i % 10 == 5;
                    if (flag) {
                        IEnergyStorage energyStorage;
                        BrushableBlockEntity brushableblockentity;
                        boolean flag1;
                        BlockEntity blockentity;
                        SoundEvent soundevent;
                        BlockPos blockpos = blockhitresult.getBlockPos();
                        BlockState blockstate = pLevel.getBlockState(blockpos);
                        HumanoidArm humanoidarm = pLivingEntity.getUsedItemHand() == InteractionHand.MAIN_HAND ? player.getMainArm() : player.getMainArm().getOpposite();
                        this.spawnDustParticles(pLevel, blockhitresult, blockstate, pLivingEntity.getViewVector(0.0f), humanoidarm);
                        Block $$18 = blockstate.getBlock();
                        if ($$18 instanceof BrushableBlock) {
                            BrushableBlock brushableblock = (BrushableBlock)$$18;
                            soundevent = brushableblock.getBrushSound();
                        } else {
                            soundevent = SoundEvents.BRUSH_GENERIC;
                        }
                        pLevel.playSound(player, blockpos, soundevent, SoundSource.BLOCKS);
                        if (!pLevel.isClientSide() && (blockentity = pLevel.getBlockEntity(blockpos)) instanceof BrushableBlockEntity && (flag1 = (brushableblockentity = (BrushableBlockEntity)blockentity).brush(pLevel.getGameTime(), player, blockhitresult.getDirection())) && player != null && (energyStorage = (IEnergyStorage)pStack.getCapability(Capabilities.EnergyStorage.ITEM)) != null) {
                            energyStorage.extractEnergy(this.getMaxTransferRate() - 24, false);
                        }
                    }
                    return;
                }
            }
            pLivingEntity.releaseUsingItem();
        } else {
            pLivingEntity.releaseUsingItem();
        }
    }

    private HitResult calculateHitResult(Player pPlayer) {
        return ProjectileUtil.getHitResultOnViewVector((Entity)pPlayer, p_281111_ -> p_281111_.isSpectator() && p_281111_.isPickable(), (double)pPlayer.blockInteractionRange());
    }

    public int getUseDuration(ItemStack pStack, LivingEntity pLivingEntity) {
        return 100;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        this.addTooltip(stack, context, tooltip, flagIn);
        MutableComponent press = Component.translatable((String)"instrumentus.tooltip.press_shift").withStyle(ChatFormatting.GRAY);
        MutableComponent empty = Component.literal((String)"");
        MutableComponent pressed1 = Component.translatable((String)"instrumentus.tooltip.brush_1").withStyle(ChatFormatting.GRAY);
        MutableComponent pressed2 = Component.translatable((String)"instrumentus.tooltip.brush_2").withStyle(ChatFormatting.GRAY);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)press);
            tooltip.add((Component)empty);
            tooltip.add((Component)pressed1);
            tooltip.add((Component)pressed2);
        } else {
            tooltip.add((Component)press);
        }
    }

    public int getBarWidth(ItemStack stack) {
        return this.getEnergyBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return this.getEnergyBarColor(stack);
    }

    public boolean isDamaged(ItemStack stack) {
        return this.isEnergyBelowZero(stack);
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.isEnergyBarVisible(stack);
    }

    private void spawnDustParticles(Level pLevel, BlockHitResult pHitResult, BlockState pState, Vec3 pPos, HumanoidArm pArm) {
        double d0 = 3.0;
        int i = pArm == HumanoidArm.RIGHT ? 1 : -1;
        int j = pLevel.getRandom().nextInt(7, 12);
        BlockParticleOption blockparticleoption = new BlockParticleOption(ParticleTypes.BLOCK, pState);
        Direction direction = pHitResult.getDirection();
        DustParticlesDelta brushitem$dustparticlesdelta = DustParticlesDelta.fromDirection(pPos, direction);
        Vec3 vec3 = pHitResult.getLocation();
        for (int k = 0; k < j; ++k) {
            pLevel.addParticle((ParticleOptions)blockparticleoption, vec3.x - (double)(direction == Direction.WEST ? 1.0E-6f : 0.0f), vec3.y, vec3.z - (double)(direction == Direction.NORTH ? 1.0E-6f : 0.0f), brushitem$dustparticlesdelta.xd() * (double)i * 3.0 * pLevel.getRandom().nextDouble(), 0.0, brushitem$dustparticlesdelta.zd() * (double)i * 3.0 * pLevel.getRandom().nextDouble());
        }
    }

    record DustParticlesDelta(double xd, double yd, double zd) {
        private static final double ALONG_SIDE_DELTA = 1.0;
        private static final double OUT_FROM_SIDE_DELTA = 0.1;

        public static DustParticlesDelta fromDirection(Vec3 pPos, Direction pDirection) {
            double d0 = 0.0;
            return switch (pDirection) {
                case Direction.DOWN, Direction.UP -> new DustParticlesDelta(pPos.z(), 0.0, -pPos.x());
                case Direction.NORTH -> new DustParticlesDelta(1.0, 0.0, -0.1);
                case Direction.SOUTH -> new DustParticlesDelta(-1.0, 0.0, 0.1);
                case Direction.WEST -> new DustParticlesDelta(-0.1, 0.0, -1.0);
                case Direction.EAST -> new DustParticlesDelta(0.1, 0.0, 1.0);
                default -> throw new IncompatibleClassChangeError();
            };
        }
    }
}

