/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.items;

import com.beanbot.instrumentus.common.items.interfaces.IEnergyItem;
import com.beanbot.instrumentus.common.items.interfaces.IItemLightningChargeable;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyAxeItem
extends DiggerItem
implements IItemLightningChargeable,
IEnergyItem {
    public EnergyAxeItem(Tier tier, float attackDamageIn, float attackSpeedIn) {
        super(tier, BlockTags.MINEABLE_WITH_AXE, new Item.Properties().attributes(AxeItem.createAttributes((Tier)tier, (float)attackDamageIn, (float)attackSpeedIn)).durability(0).stacksTo(1).fireResistant());
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player;
        BlockPos blockpos;
        Level level = context.getLevel();
        Optional<BlockState> optional = this.evaluateNewBlockState(level, blockpos = context.getClickedPos(), player = context.getPlayer(), level.getBlockState(blockpos), context);
        if (optional.isEmpty()) {
            return InteractionResult.PASS;
        }
        ItemStack itemstack = context.getItemInHand();
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockpos, itemstack);
        }
        if (player != null) {
            IEnergyStorage energyStorage = (IEnergyStorage)context.getItemInHand().getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null) {
                return InteractionResult.FAIL;
            }
            if (energyStorage.getEnergyStored() == 0) {
                return InteractionResult.FAIL;
            }
            level.setBlock(blockpos, optional.get(), 11);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)optional.get()));
            energyStorage.extractEnergy(this.getMaxTransferRate() - 24, false);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private Optional<BlockState> evaluateNewBlockState(Level level, BlockPos blockPos, @Nullable Player player, BlockState state, UseOnContext context) {
        Optional<BlockState> optional = Optional.ofNullable(state.getToolModifiedState(context, ItemAbilities.AXE_STRIP, false));
        if (optional.isPresent()) {
            level.playSound(player, blockPos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            return optional;
        }
        Optional<BlockState> optional1 = Optional.ofNullable(state.getToolModifiedState(context, ItemAbilities.AXE_SCRAPE, false));
        if (optional1.isPresent()) {
            level.playSound(player, blockPos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(player, 3005, blockPos, 0);
            return optional1;
        }
        Optional<BlockState> optional2 = Optional.ofNullable(state.getToolModifiedState(context, ItemAbilities.AXE_WAX_OFF, false));
        if (optional2.isPresent()) {
            level.playSound(player, blockPos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(player, 3004, blockPos, 0);
            return optional2;
        }
        return Optional.empty();
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility toolAction) {
        return ItemAbilities.DEFAULT_AXE_ACTIONS.contains(toolAction);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return this.energyDamageEnemy(stack, target, attacker);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null) {
            return 0.0f;
        }
        if (energyStorage.getEnergyStored() <= 0) {
            return 0.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean mineBlock(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        Player player;
        if (!(stack.getItem() instanceof IEnergyItem)) {
            return false;
        }
        if (entityLiving instanceof Player && !(player = (Player)entityLiving).isCreative()) {
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null) {
                return false;
            }
            if (state.getDestroySpeed((BlockGetter)worldIn, pos) != 0.0f) {
                energyStorage.extractEnergy(this.getMaxTransferRate() - 24, false);
            }
        }
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        this.addTooltip(stack, context, tooltip, flagIn);
    }

    public int getBarWidth(ItemStack stack) {
        return this.getEnergyBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return this.getEnergyBarColor(stack);
    }

    public boolean isDamaged(ItemStack stack) {
        return this.isEnergyBelowZero(stack);
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.isEnergyBarVisible(stack);
    }
}

