/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.items;

import com.beanbot.instrumentus.client.particles.InstrumentusParticles;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;

public class BurnerItem
extends Item {
    public BurnerItem() {
        super(new Item.Properties().durability(300).stacksTo(1));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null && this.calculateHitResult(player).getType() == HitResult.Type.BLOCK) {
            player.startUsingItem(context.getHand());
        }
        return InteractionResult.CONSUME;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        MutableComponent press = Component.translatable((String)"instrumentus.tooltip.press_shift").withStyle(ChatFormatting.GRAY);
        MutableComponent empty = Component.literal((String)"");
        MutableComponent pressed1 = Component.translatable((String)"instrumentus.tooltip.soulcopper_burner_1").withStyle(ChatFormatting.GRAY);
        MutableComponent pressed2 = Component.translatable((String)"instrumentus.tooltip.soulcopper_burner_2").withStyle(ChatFormatting.GRAY);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)press);
            tooltip.add((Component)empty);
            tooltip.add((Component)pressed1);
            tooltip.add((Component)pressed2);
        } else {
            tooltip.add((Component)press);
        }
    }

    private HitResult calculateHitResult(Player player) {
        return ProjectileUtil.getHitResultOnViewVector((Entity)player, p -> !p.isSpectator() && p.isPickable(), (double)player.blockInteractionRange());
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.BRUSH;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return 40;
    }

    public void onUseTick(@NotNull Level level, @NotNull LivingEntity entity, @NotNull ItemStack stack, int remainingUseDuration) {
        if (remainingUseDuration >= 0 && entity instanceof Player) {
            Player player = (Player)entity;
            HitResult hitResult = this.calculateHitResult(player);
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                if (hitResult.getType() == HitResult.Type.BLOCK) {
                    boolean flag;
                    int i = this.getUseDuration(stack, entity) - remainingUseDuration + 1;
                    boolean bl = flag = i % 10 == 5;
                    if (flag) {
                        WeatheringCopper weatheringCopper;
                        Block block;
                        HumanoidArm humanoidArm;
                        BlockPos blockPos = blockHitResult.getBlockPos();
                        BlockState blockState = level.getBlockState(blockPos);
                        HumanoidArm humanoidArm2 = humanoidArm = entity.getUsedItemHand() == InteractionHand.MAIN_HAND ? player.getMainArm() : player.getMainArm().getOpposite();
                        if (blockState.getRenderShape() != RenderShape.INVISIBLE) {
                            this.spawnFlameParticle(level, blockHitResult, entity.getViewVector(0.0f), humanoidArm);
                        }
                        SoundEvent soundevent = SoundEvents.CAMPFIRE_CRACKLE;
                        level.playSound(player, blockPos, soundevent, SoundSource.BLOCKS);
                        if (!level.isClientSide() && (block = blockState.getBlock()) instanceof WeatheringCopper && (weatheringCopper = (WeatheringCopper)block).getNext(blockState).isPresent() && player.getUseItemRemainingTicks() <= 6) {
                            level.setBlock(blockPos, Objects.requireNonNull(WeatheringCopper.getNext((Block)blockState.getBlock()).map(p -> p.withPropertiesOf(blockState)).orElse(null)), 3);
                            EquipmentSlot equipmentSlot = stack.equals(player.getItemBySlot(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
                            stack.hurtAndBreak(1, entity, equipmentSlot);
                        }
                    }
                    return;
                }
            }
            entity.releaseUsingItem();
        } else {
            entity.releaseUsingItem();
        }
    }

    private void spawnFlameParticle(Level level, BlockHitResult hitResult, Vec3 pos, HumanoidArm arm) {
        int i = arm == HumanoidArm.RIGHT ? 1 : -1;
        int j = level.getRandom().nextInt(7, 12);
        Direction direction = hitResult.getDirection();
        FlameParticleDelta flameParticleDelta = FlameParticleDelta.fromDirection(direction);
        Vec3 vec3 = hitResult.getLocation();
        double d0 = 0.5;
        for (int k = 0; k < j; ++k) {
            level.addParticle((ParticleOptions)((SimpleParticleType)InstrumentusParticles.COPPER_SOUL_FIRE_FLAME_PARTICLE.get()), vec3.x, vec3.y, vec3.z, flameParticleDelta.x() * (double)i * d0 * level.getRandom().nextDouble(), flameParticleDelta.y() * (double)i * d0 * level.getRandom().nextDouble(), flameParticleDelta.z() * (double)i * d0 * level.getRandom().nextDouble());
        }
    }

    public boolean canPerformAction(@NotNull ItemStack stack, @NotNull ItemAbility itemAbility) {
        return itemAbility == ItemAbilities.AXE_WAX_OFF;
    }

    record FlameParticleDelta(double x, double y, double z) {
        public static FlameParticleDelta fromDirection(Direction direction) {
            double d0 = 0.2;
            return switch (direction) {
                default -> throw new MatchException(null, null);
                case Direction.UP -> new FlameParticleDelta(0.0, d0, 0.0);
                case Direction.DOWN -> new FlameParticleDelta(0.0, -d0, 0.0);
                case Direction.NORTH -> new FlameParticleDelta(0.0, 0.0, -d0);
                case Direction.SOUTH -> new FlameParticleDelta(0.0, 0.0, d0);
                case Direction.WEST -> new FlameParticleDelta(-d0, 0.0, 0.0);
                case Direction.EAST -> new FlameParticleDelta(d0, 0.0, 0.0);
            };
        }
    }
}

